/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.impl.Jar;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public interface SecureJar {
    public ModuleDataProvider moduleDataProvider();

    public Path getPrimaryPath();

    public CodeSigner[] getManifestSigners();

    public Status verifyPath(Path var1);

    public Status getFileStatus(String var1);

    public Attributes getTrustedManifestEntries(String var1);

    public boolean hasSecurityData();

    public static SecureJar from(Path ... paths) {
        return SecureJar.from((SecureJar jar) -> JarMetadata.from(jar, paths), paths);
    }

    public static SecureJar from(BiPredicate<String, String> filter, Path ... paths) {
        return SecureJar.from((SecureJar jar) -> JarMetadata.from(jar, paths), filter, paths);
    }

    public static SecureJar from(Function<SecureJar, JarMetadata> metadataSupplier, Path ... paths) {
        return SecureJar.from(metadataSupplier, null, paths);
    }

    public static SecureJar from(Function<SecureJar, JarMetadata> metadataSupplier, BiPredicate<String, String> filter, Path ... paths) {
        return new Jar(metadataSupplier, filter, paths);
    }

    @Deprecated(forRemoval=true, since="2.2")
    public static SecureJar from(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataSupplier, Path ... paths) {
        return SecureJar.from(defaultManifest, metadataSupplier, null, paths);
    }

    @Deprecated(forRemoval=true, since="2.2")
    public static SecureJar from(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataSupplier, BiPredicate<String, String> filter, Path ... paths) {
        return new Jar(defaultManifest, metadataSupplier, filter, paths);
    }

    public Set<String> getPackages();

    public List<Provider> getProviders();

    public String name();

    public Path getPath(String var1, String ... var2);

    public Path getRootPath();

    public static enum Status {
        NONE,
        INVALID,
        UNVERIFIED,
        VERIFIED;

    }

    public record Provider(String serviceName, List<String> providers) {
        @Deprecated
        public static Provider fromPath(Path path, BiPredicate<String, String> filter) {
            return Jar.getProvider(path, filter);
        }
    }

    public static interface ModuleDataProvider {
        public String name();

        public ModuleDescriptor descriptor();

        public URI uri();

        public Optional<URI> findFile(String var1);

        public Optional<InputStream> open(String var1);

        public Manifest getManifest();

        public CodeSigner[] verifyAndGetSigners(String var1, byte[] var2);
    }
}

