/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.PredicateVisitor;
import cpw.mods.modlauncher.api.ITransformerActivity;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import java.util.List;
import java.util.function.Supplier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

record VotingContext(String getClassName, boolean doesClassExist, Supplier<byte[]> sha256, List<ITransformerActivity> getAuditActivities, String reason, NodeHolder node) implements ITransformerVotingContext
{
    private static final Object[] EMPTY = new Object[0];

    VotingContext(String className, boolean classExists, Supplier<byte[]> sha256sum, List<ITransformerActivity> activities, String reason) {
        this(className, classExists, sha256sum, activities, reason, new NodeHolder());
    }

    @Override
    public byte[] getInitialClassSha256() {
        return this.sha256.get();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    <T> void setNode(T node) {
        this.node.value = node;
    }

    @Override
    public boolean applyFieldPredicate(ITransformerVotingContext.FieldPredicate fieldPredicate) {
        FieldNode fn = (FieldNode)this.node.value;
        PredicateVisitor predicateVisitor = new PredicateVisitor(fieldPredicate);
        fn.accept((ClassVisitor)predicateVisitor);
        return predicateVisitor.getResult();
    }

    @Override
    public boolean applyMethodPredicate(ITransformerVotingContext.MethodPredicate methodPredicate) {
        MethodNode mn = (MethodNode)this.node.value;
        PredicateVisitor predicateVisitor = new PredicateVisitor(methodPredicate);
        mn.accept((ClassVisitor)predicateVisitor);
        return predicateVisitor.getResult();
    }

    @Override
    public boolean applyClassPredicate(ITransformerVotingContext.ClassPredicate classPredicate) {
        ClassNode cn = (ClassNode)this.node.value;
        PredicateVisitor predicateVisitor = new PredicateVisitor(classPredicate);
        cn.accept((ClassVisitor)predicateVisitor);
        return predicateVisitor.getResult();
    }

    @Override
    public boolean applyInstructionPredicate(ITransformerVotingContext.InsnPredicate insnPredicate) {
        MethodNode mn = (MethodNode)this.node.value;
        boolean result = false;
        AbstractInsnNode[] insnNodes = mn.instructions.toArray();
        for (int i = 0; i < insnNodes.length; ++i) {
            result |= insnPredicate.test(i, insnNodes[i].getOpcode(), VotingContext.toObjectArray(insnNodes[0]));
        }
        return result;
    }

    private static Object[] toObjectArray(AbstractInsnNode insnNode) {
        AbstractInsnNode abstractInsnNode = insnNode;
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            return new Object[]{methodInsnNode.name, methodInsnNode.desc, methodInsnNode.owner, methodInsnNode.itf};
        }
        abstractInsnNode = insnNode;
        if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            return new Object[]{fieldInsnNode.name, fieldInsnNode.desc, fieldInsnNode.owner};
        }
        return EMPTY;
    }

    private static final class NodeHolder {
        private Object value;

        private NodeHolder() {
        }
    }
}

