/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.internal.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class GeometryLoaderManager {
    private static Map<ResourceLocation, IGeometryLoader> LOADERS;
    private static String LOADER_LIST;

    @Nullable
    public static IGeometryLoader get(ResourceLocation name) {
        return LOADERS.get(name);
    }

    public static String getLoaderList() {
        return LOADER_LIST;
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<ResourceLocation, IGeometryLoader> loaders = new HashMap<ResourceLocation, IGeometryLoader>();
        ModelEvent.RegisterGeometryLoaders.BUS.post((Event)new ModelEvent.RegisterGeometryLoaders(loaders));
        LOADERS = Map.copyOf(loaders);
        LOADER_LIST = loaders.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
    }

    private GeometryLoaderManager() {
    }
}

