/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;

public sealed interface InputEvent {

    public static final class InteractionKeyMappingTriggered
    extends MutableEvent
    implements Cancellable,
    InputEvent {
        public static final CancellableEventBus<InteractionKeyMappingTriggered> BUS = CancellableEventBus.create(InteractionKeyMappingTriggered.class);
        private final int button;
        private final KeyMapping keyMapping;
        private final InteractionHand hand;
        private boolean handSwing = true;

        @ApiStatus.Internal
        public InteractionKeyMappingTriggered(int button, KeyMapping keyMapping, InteractionHand hand) {
            this.button = button;
            this.keyMapping = keyMapping;
            this.hand = hand;
        }

        public void setSwingHand(boolean value) {
            this.handSwing = value;
        }

        public boolean shouldSwingHand() {
            return this.handSwing;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        public boolean isAttack() {
            return this.button == 0;
        }

        public boolean isUseItem() {
            return this.button == 1;
        }

        public boolean isPickBlock() {
            return this.button == 2;
        }

        public KeyMapping getKeyMapping() {
            return this.keyMapping;
        }
    }

    public record Key(KeyEvent getInfo, int getAction) implements RecordEvent,
    InputEvent
    {
        public static final EventBus<Key> BUS = EventBus.create(Key.class);

        public int getKey() {
            return this.getInfo().key();
        }

        public int getScanCode() {
            return this.getInfo().scancode();
        }

        public int getModifiers() {
            return this.getInfo().modifiers();
        }
    }

    public record MouseScrollingEvent(double getDeltaX, double getDeltaY, boolean isLeftDown, boolean isMiddleDown, boolean isRightDown, double getMouseX, double getMouseY) implements Cancellable,
    InputEvent,
    RecordEvent
    {
        public static final CancellableEventBus<MouseScrollingEvent> BUS = CancellableEventBus.create(MouseScrollingEvent.class);
    }

    public static sealed interface MouseButton
    extends InputEvent {
        public MouseButtonInfo getInfo();

        default public int getButton() {
            return this.getInfo().button();
        }

        public int getAction();

        default public int getModifiers() {
            return this.getInfo().modifiers();
        }

        public record Post(MouseButtonInfo getInfo, int getAction) implements MouseButton,
        RecordEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(MouseButtonInfo getInfo, int getAction) implements Cancellable,
        MouseButton,
        RecordEvent
        {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        }
    }
}

