/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.SelfDestructing;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

public sealed interface EntityRenderersEvent {

    public static final class CreateSkullModels
    extends MutableEvent
    implements EntityRenderersEvent {
        public static final EventBus<CreateSkullModels> BUS = EventBus.create(CreateSkullModels.class);
        private final ImmutableMap.Builder<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> builder;

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<CreateSkullModels> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        @ApiStatus.Internal
        public CreateSkullModels(ImmutableMap.Builder<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> builder) {
            this.builder = builder;
        }

        public void registerSkullModel(SkullBlock.Type type, Function<EntityModelSet, SkullModelBase> model) {
            this.builder.put((Object)type, model);
        }
    }

    public static final class AddLayers
    extends MutableEvent
    implements EntityRenderersEvent {
        public static final EventBus<AddLayers> BUS = EventBus.create(AddLayers.class);
        private final Map<EntityType<?>, EntityRenderer<?, ?>> renderers;
        private final Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers;
        private final Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers;
        private final EntityRendererProvider.Context context;

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<AddLayers> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        @ApiStatus.Internal
        public AddLayers(Map<EntityType<?>, EntityRenderer<?, ?>> renderers, Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers, Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers, EntityRendererProvider.Context context) {
            this.renderers = renderers;
            this.playerRenderers = playerRenderers;
            this.mannequinRenderers = mannequinRenderers;
            this.context = context;
        }

        public Set<PlayerModelType> getModelTypes() {
            return this.playerRenderers.keySet();
        }

        @Nullable
        public <R extends EntityRenderer<? extends Player, ?>> R getPlayerRenderer(PlayerModelType modelType) {
            return (R)((EntityRenderer)this.playerRenderers.get(modelType));
        }

        @Nullable
        public <R extends EntityRenderer<? extends ClientMannequin, ?>> R getMannequinRenderer(PlayerModelType modelType) {
            return (R)((EntityRenderer)this.mannequinRenderers.get(modelType));
        }

        @Nullable
        public <T extends LivingEntity, S extends EntityRenderState, R extends EntityRenderer<T, S>> R getEntityRenderer(EntityType<? extends T> entityType) {
            return (R)this.renderers.get(entityType);
        }

        public EntityModelSet getEntityModels() {
            return this.context.getModelSet();
        }

        public EntityRendererProvider.Context getContext() {
            return this.context;
        }
    }

    @NullMarked
    public record RegisterRenderers() implements SelfDestructing,
    RecordEvent,
    EntityRenderersEvent
    {
        public static final EventBus<RegisterRenderers> BUS = EventBus.create(RegisterRenderers.class);

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<RegisterRenderers> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        public <T extends Entity> void registerEntityRenderer(EntityType<? extends T> entityType, EntityRendererProvider<T> entityRendererProvider) {
            EntityRenderers.register(entityType, entityRendererProvider);
        }

        public <T extends BlockEntity, S extends BlockEntityRenderState> void registerBlockEntityRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T, S> blockEntityRendererProvider) {
            BlockEntityRenderers.register(blockEntityType, blockEntityRendererProvider);
        }
    }

    @NullMarked
    public record RegisterLayerDefinitions() implements SelfDestructing,
    RecordEvent,
    EntityRenderersEvent
    {
        public static final EventBus<RegisterLayerDefinitions> BUS = EventBus.create(RegisterLayerDefinitions.class);

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<RegisterLayerDefinitions> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        public void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
            ForgeHooksClient.registerLayerDefinition(layerLocation, supplier);
        }
    }
}

