/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LogMessageAdapter;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.ForgePayload;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.packets.Acknowledge;
import net.minecraftforge.network.packets.ChannelVersions;
import net.minecraftforge.network.packets.ConfigData;
import net.minecraftforge.network.packets.LoginWrapper;
import net.minecraftforge.network.packets.MismatchData;
import net.minecraftforge.network.packets.ModVersions;
import net.minecraftforge.network.packets.RegistryData;
import net.minecraftforge.network.packets.RegistryList;
import net.minecraftforge.network.tasks.ChannelVersionsTask;
import net.minecraftforge.network.tasks.ModVersionsTask;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ForgePacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"FORGE_PACKET_HANDLER");
    private Set<ResourceLocation> registriesToReceive;
    private Map<ResourceLocation, ForgeRegistry.Snapshot> registrySnapshots = new HashMap<ResourceLocation, ForgeRegistry.Snapshot>();
    private int nextAckId = 0;
    private Int2ObjectMap<BiConsumer<Acknowledge, CustomPayloadEvent.Context>> pendingAcknowledgments = new Int2ObjectOpenHashMap();

    ForgePacketHandler(Connection connection) {
    }

    public int expectAck(BiConsumer<Acknowledge, CustomPayloadEvent.Context> consumer) {
        int id = this.nextAckId++;
        this.pendingAcknowledgments.put(id, consumer);
        return id;
    }

    void handleLoginWrapper(LoginWrapper msg, CustomPayloadEvent.Context ctx) {
        ForgeHooks.onCustomPayload(new CustomPayloadEvent(msg.name(), ForgePayload.create(msg.name(), msg.data()), ctx, -1));
    }

    void handleClientAck(Acknowledge msg, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        BiConsumer consumer = (BiConsumer)this.pendingAcknowledgments.remove(msg.token());
        if (consumer != null) {
            LOGGER.debug(MARKER, "Received acknowledgement {} from client", (Object)msg.token());
            consumer.accept(msg, ctx);
        } else {
            LOGGER.error(MARKER, "Received unknown acknowledgement {} from client", (Object)msg.token());
            ctx.getConnection().disconnect((Component)Component.literal((String)("Illegal Acknowledge packet received, unknown token: " + Integer.toHexString(msg.token()))));
        }
    }

    void handleModVersions(ModVersions list, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        LOGGER.debug(MARKER, "Received {} connection with modlist [{}]", (Object)(ctx.isClientSide() ? "server" : "client"), (Object)list.mods().keySet().stream().sorted().collect(Collectors.joining(", ")));
        NetworkContext nctx = NetworkContext.get(ctx.getConnection());
        nctx.modList.clear();
        nctx.modList.putAll(list.mods());
        if (ctx.isClientSide()) {
            NetworkInitialization.CONFIG.send(ModVersions.create(), ctx.getConnection());
            LOGGER.debug(MARKER, "Accepted server connection");
            nctx.setConnectionType(ConnectionType.MODDED);
        } else {
            nctx.finishTask(ModVersionsTask.TYPE);
        }
    }

    void handleChannelVersions(ChannelVersions list, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        LOGGER.debug(MARKER, "Received {} connection with channels [{}]", (Object)(ctx.isClientSide() ? "server" : "client"), (Object)list.channels().keySet().stream().map(ResourceLocation::toString).sorted().collect(Collectors.joining(", ")));
        NetworkContext nctx = NetworkContext.get(ctx.getConnection());
        nctx.channelList.clear();
        nctx.channelList.putAll(list.channels());
        NetworkContext.NetworkMismatchData invalid = NetworkRegistry.validateChannels(list.channels(), ctx.isServerSide());
        if (invalid != null) {
            LOGGER.error(MARKER, "Terminating connection with {}, mismatched channel list", (Object)(ctx.isClientSide() ? "server" : "client"));
            nctx.mismatchData = new NetworkContext.NetworkMismatchData(invalid.mismatched(), invalid.missing(), invalid.fromServer(), nctx.getModList());
            if (ctx.isServerSide()) {
                NetworkInitialization.CONFIG.reply(new MismatchData(nctx.mismatchData), ctx);
            }
            ctx.getConnection().disconnect((Component)Component.literal((String)"Connection closed - mismatched mod channel list"));
            return;
        }
        if (ctx.isClientSide()) {
            NetworkInitialization.CONFIG.send(new ChannelVersions(), ctx.getConnection());
        } else {
            nctx.finishTask(ChannelVersionsTask.TYPE);
        }
    }

    void handleModMismatchData(MismatchData data, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        NetworkContext nctx = NetworkContext.get(ctx.getConnection());
        nctx.mismatchData = new NetworkContext.NetworkMismatchData(data.mismatched(), data.missing(), true, nctx.getModList());
        LOGGER.error(MARKER, "Channels [{}] rejected their client side version number", (Object)Stream.concat(data.missing().stream(), data.mismatched().keySet().stream()).map(Object::toString).collect(Collectors.joining(", ")));
        LOGGER.error(MARKER, "Terminating connection with server, mismatched mod list");
        ctx.getConnection().disconnect((Component)Component.literal((String)"Connection closed - mismatched mod channel list"));
    }

    void handleRegistryList(RegistryList list, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ArrayList<String> missing = new ArrayList<String>();
        Set<ResourceKey<Registry<?>>> clientDataPackRegistries = DataPackRegistriesHooks.getSyncedCustomRegistries();
        for (ResourceKey<? extends Registry<?>> resourceKey : list.datapacks()) {
            if (clientDataPackRegistries.contains(resourceKey)) continue;
            LOGGER.error(MARKER, "Missing required datapack registry: {}", (Object)resourceKey.location());
            missing.add(resourceKey.location().toString());
        }
        if (!missing.isEmpty()) {
            ctx.getConnection().disconnect((Component)Component.translatable((String)"fml.menu.multiplayer.missingdatapackregistries", (Object[])new Object[]{String.join((CharSequence)", ", missing)}));
            return;
        }
        NetworkInitialization.CONFIG.reply(new Acknowledge(list.token()), ctx);
        this.registriesToReceive = new HashSet<ResourceLocation>(list.normal());
        this.registrySnapshots.clear();
        LOGGER.debug(MARKER, "Expecting {} registries: {}", (Object)this.registriesToReceive.size(), (Object)this.registriesToReceive.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    void handleRegistryData(RegistryData msg, CustomPayloadEvent.Context ctx) {
        ctx.setPacketHandled(true);
        LOGGER.debug(MARKER, "Received registry data packet for {} token {}", (Object)msg.name(), (Object)msg.token());
        if (!this.registriesToReceive.remove(msg.name())) {
            LOGGER.error(MARKER, "Received unexpected registry data packet for {}", (Object)msg.name());
            ctx.getConnection().disconnect((Component)Component.literal((String)("Illegal Registry Data packet received, unexpected registry: " + String.valueOf(msg.name()))));
            return;
        }
        this.registrySnapshots.put(msg.name(), msg.data());
        boolean continueHandshake = true;
        if (this.registriesToReceive.isEmpty()) {
            continueHandshake = this.handleRegistryLoading(ctx);
        }
        if (!continueHandshake) {
            LOGGER.error(MARKER, "Connection closed, not continuing handshake");
        } else {
            NetworkInitialization.CONFIG.reply(new Acknowledge(msg.token()), ctx);
        }
    }

    private boolean handleRegistryLoading(CustomPayloadEvent.Context ctx) {
        NetworkContext nctx = NetworkContext.get(ctx.getConnection());
        CountDownLatch block = new CountDownLatch(1);
        AtomicReference errorData = new AtomicReference();
        ctx.enqueueWork(() -> {
            LOGGER.debug(MARKER, "Injecting registry snapshot from server.");
            Multimap<ResourceLocation, ResourceLocation> missingData = GameData.injectSnapshot(this.registrySnapshots, false, false);
            LOGGER.debug(MARKER, "Snapshot injected.");
            if (!missingData.isEmpty()) {
                LOGGER.error(MARKER, "Missing registry data for connection:\n{}", (Object)LogMessageAdapter.adapt(sb -> missingData.forEach((k, v) -> sb.append("\t").append(k).append(": ").append(v).append('\n'))));
                List<String> missingMods = missingData.values().stream().map(ResourceLocation::getNamespace).distinct().toList();
                HashMap<ResourceLocation, NetworkContext.NetworkMismatchData.Version> mismatched = new HashMap<ResourceLocation, NetworkContext.NetworkMismatchData.Version>();
                HashSet<ResourceLocation> missing = new HashSet<ResourceLocation>();
                for (String id : missingMods) {
                    ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)id, (String)"");
                    ModContainer container = ModList.get().getModContainerById(id).orElse(null);
                    if (container != null) {
                        mismatched.put(key, new NetworkContext.NetworkMismatchData.Version(container.getModInfo().getVersion().toString(), ""));
                        continue;
                    }
                    missing.add(key);
                }
                errorData.set(new NetworkContext.NetworkMismatchData(mismatched, missing, true, nctx.getModList()));
            }
            block.countDown();
        });
        LOGGER.debug(MARKER, "Waiting for registries to load.");
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        NetworkContext.NetworkMismatchData mismatchData = (NetworkContext.NetworkMismatchData)errorData.get();
        if (mismatchData != null) {
            LOGGER.error(MARKER, "Failed to load registry, closing connection.");
            nctx.mismatchData = mismatchData;
            ctx.getConnection().disconnect((Component)Component.literal((String)"Failed to synchronize registry data from server, closing connection"));
            return false;
        }
        LOGGER.debug(MARKER, "Registry load complete, continuing handshake.");
        return true;
    }

    void handleConfigSync(ConfigData msg, CustomPayloadEvent.Context ctx) {
        ModConfig cfg;
        ctx.setPacketHandled(true);
        LOGGER.debug(MARKER, "Received config sync from server for {}", (Object)msg.name());
        if (!ctx.getConnection().isMemoryConnection() && (cfg = (ModConfig)ConfigTracker.INSTANCE.fileMap().get(msg.name())) != null) {
            cfg.acceptSyncedConfig(msg.data());
        }
    }
}

