/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public sealed interface ModelEvent {

    public static final class RegisterGeometryLoaders
    implements IModBusEvent,
    ModelEvent {
        private final Map<ResourceLocation, IGeometryLoader> loaders;

        public static EventBus<RegisterGeometryLoaders> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterGeometryLoaders.class);
        }

        @ApiStatus.Internal
        public RegisterGeometryLoaders(Map<ResourceLocation, IGeometryLoader> loaders) {
            this.loaders = loaders;
        }

        public void register(String name, IGeometryLoader loader) {
            String namespace = ModLoadingContext.get().getActiveNamespace();
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name);
            Preconditions.checkArgument((!this.loaders.containsKey(key) ? 1 : 0) != 0, (Object)("Geometry loader already registered: " + String.valueOf(key)));
            this.loaders.put(key, loader);
        }
    }

    public static final class RegisterModelStateDefinitions
    implements IModBusEvent,
    ModelEvent {
        private final Map<ResourceLocation, StateDefinition<Block, BlockState>> states = new HashMap<ResourceLocation, StateDefinition<Block, BlockState>>();
        private final Map<ResourceLocation, StateDefinition<Block, BlockState>> view = Collections.unmodifiableMap(this.states);

        public static EventBus<RegisterModelStateDefinitions> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterModelStateDefinitions.class);
        }

        @ApiStatus.Internal
        public RegisterModelStateDefinitions() {
        }

        public Map<ResourceLocation, StateDefinition<Block, BlockState>> getStates() {
            return this.view;
        }

        public void register(ResourceLocation key, StateDefinition<Block, BlockState> value) {
            this.states.put(key, value);
        }
    }

    public record BakingCompleted(ModelManager getModelManager, ModelBakery getModelBakery) implements IModBusEvent,
    ModelEvent
    {
        public static EventBus<BakingCompleted> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, BakingCompleted.class);
        }
    }

    public record ModifyBakingResult(ModelBakery getModelBakery, ModelBakery.BakingResult getResults) implements IModBusEvent,
    ModelEvent
    {
        public static EventBus<ModifyBakingResult> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, ModifyBakingResult.class);
        }
    }
}

