/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class DimensionSpecialEffectsManager {
    private static Map<ResourceLocation, DimensionSpecialEffects> EFFECTS;
    private static DimensionSpecialEffects DEFAULT_EFFECTS;

    private DimensionSpecialEffectsManager() {
    }

    public static DimensionSpecialEffects getForType(ResourceLocation type) {
        return EFFECTS.getOrDefault(type, DEFAULT_EFFECTS);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<ResourceLocation, DimensionSpecialEffects> effects = new HashMap<ResourceLocation, DimensionSpecialEffects>();
        DEFAULT_EFFECTS = DimensionSpecialEffectsManager.preRegisterVanillaEffects(effects);
        RegisterDimensionSpecialEffectsEvent event = new RegisterDimensionSpecialEffectsEvent(effects);
        ModLoader.postEventWrapContainerInModOrder((IModBusEvent)event);
        EFFECTS = Map.copyOf(effects);
    }

    private static DimensionSpecialEffects preRegisterVanillaEffects(Map<ResourceLocation, DimensionSpecialEffects> effects) {
        DimensionSpecialEffects.OverworldEffects overworldEffects = new DimensionSpecialEffects.OverworldEffects();
        effects.put(BuiltinDimensionTypes.OVERWORLD_EFFECTS, (DimensionSpecialEffects)overworldEffects);
        effects.put(BuiltinDimensionTypes.NETHER_EFFECTS, (DimensionSpecialEffects)new DimensionSpecialEffects.NetherEffects());
        effects.put(BuiltinDimensionTypes.END_EFFECTS, (DimensionSpecialEffects)new DimensionSpecialEffects.EndEffects());
        return overworldEffects;
    }
}

