/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class ColorResolverManager {
    private static List<ColorResolver> colorResolvers;

    private ColorResolverManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        ArrayList<ColorResolver> builder = new ArrayList<ColorResolver>();
        ModLoader.postEvent((IModBusEvent)new RegisterColorHandlersEvent.ColorResolvers(builder));
        colorResolvers = List.copyOf(builder);
    }

    public static void registerBlockTintCaches(ClientLevel level, Map<ColorResolver, BlockTintCache> target) {
        for (ColorResolver resolver : colorResolvers) {
            target.put(resolver, new BlockTintCache(pos -> level.calculateBlockTint(pos, resolver)));
        }
    }
}

