/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.timings.ForgeTimings;
import net.minecraftforge.server.timings.TimeTracker;

class TrackCommand {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#####0.00");

    TrackCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"track").then(StartTrackingCommand.register())).then(ResetTrackingCommand.register())).then(TrackResultsEntity.register())).then(TrackResultsBlockEntity.register())).then(StartTrackingCommand.register());
    }

    private static class StartTrackingCommand {
        private StartTrackingCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"start").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"te").then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
                int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
                TimeTracker.BLOCK_ENTITY_UPDATE.reset();
                TimeTracker.BLOCK_ENTITY_UPDATE.enable(duration);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.forge.tracking.be.enabled", (Object[])new Object[]{duration}), true);
                return 0;
            })))).then(Commands.literal((String)"entity").then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
                int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
                TimeTracker.ENTITY_UPDATE.reset();
                TimeTracker.ENTITY_UPDATE.enable(duration);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.forge.tracking.entity.enabled", (Object[])new Object[]{duration}), true);
                return 0;
            })));
        }
    }

    private static class ResetTrackingCommand {
        private ResetTrackingCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"te").executes(ctx -> {
                TimeTracker.BLOCK_ENTITY_UPDATE.reset();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.forge.tracking.be.reset"), true);
                return 0;
            }))).then(Commands.literal((String)"entity").executes(ctx -> {
                TimeTracker.ENTITY_UPDATE.reset();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.forge.tracking.entity.reset"), true);
                return 0;
            }));
        }
    }

    private static class TrackResultsEntity {
        private TrackResultsEntity() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return Commands.literal((String)"entity").executes(ctx -> TrackResults.execute((CommandSourceStack)ctx.getSource(), TimeTracker.ENTITY_UPDATE, data -> {
                Entity entity = (Entity)data.getObject().get();
                if (entity == null) {
                    return Component.translatable((String)"commands.forge.tracking.invalid");
                }
                BlockPos pos = entity.blockPosition();
                double averageTimings = data.getAverageTimings();
                String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + (averageTimings < 1000.0 ? "\u03bcs" : "ms");
                return Component.translatable((String)"commands.forge.tracking.timing_entry", (Object[])new Object[]{ForgeRegistries.ENTITY_TYPES.getKey(entity.getType()), entity.level().dimension().identifier().toString(), pos.getX(), pos.getY(), pos.getZ(), tickTime});
            }));
        }
    }

    private static class TrackResultsBlockEntity {
        private TrackResultsBlockEntity() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return Commands.literal((String)"te").executes(ctx -> TrackResults.execute((CommandSourceStack)ctx.getSource(), TimeTracker.BLOCK_ENTITY_UPDATE, data -> {
                BlockEntity be = (BlockEntity)data.getObject().get();
                if (be == null) {
                    return Component.translatable((String)"commands.forge.tracking.invalid");
                }
                BlockPos pos = be.getBlockPos();
                double averageTimings = data.getAverageTimings();
                String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + (averageTimings < 1000.0 ? "\u03bcs" : "ms");
                return Component.translatable((String)"commands.forge.tracking.timing_entry", (Object[])new Object[]{ForgeRegistries.BLOCK_ENTITY_TYPES.getKey(be.getType()), be.getLevel().dimension().identifier().toString(), pos.getX(), pos.getY(), pos.getZ(), tickTime});
            }));
        }
    }

    private static class TrackResults {
        private TrackResults() {
        }

        private static <T> List<ForgeTimings<T>> getSortedTimings(TimeTracker<T> tracker) {
            ArrayList<ForgeTimings<T>> list = new ArrayList<ForgeTimings<T>>();
            list.addAll((Collection<ForgeTimings<T>>)tracker.getTimingData());
            list.sort(Comparator.comparingDouble(ForgeTimings::getAverageTimings));
            Collections.reverse(list);
            return list;
        }

        private static <T> int execute(CommandSourceStack source, TimeTracker<T> tracker, Function<ForgeTimings<T>, Component> toString) {
            List<ForgeTimings<T>> timingsList = TrackResults.getSortedTimings(tracker);
            if (timingsList.isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"commands.forge.tracking.no_data"), true);
            } else {
                timingsList.stream().filter(timings -> timings.getObject().get() != null).limit(10L).forEach(timings -> source.sendSuccess(() -> (Component)toString.apply((ForgeTimings)timings), true));
            }
            return 0;
        }
    }
}

