/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.resources.Identifier;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;

public final class IdMappingEvent
extends MutableEvent {
    public static final EventBus<IdMappingEvent> BUS = EventBus.create(IdMappingEvent.class);
    private final Map<Identifier, ImmutableList<ModRemapping>> remaps;
    private final ImmutableSet<Identifier> keys;
    private final boolean isFrozen;

    public IdMappingEvent(Map<Identifier, Map<Identifier, IdRemapping>> remaps, boolean isFrozen) {
        this.isFrozen = isFrozen;
        this.remaps = Maps.newHashMap();
        remaps.forEach((name, rm) -> {
            ArrayList<ModRemapping> tmp = new ArrayList<ModRemapping>();
            rm.forEach((key, value) -> tmp.add(new ModRemapping((Identifier)name, (Identifier)key, value.currId, value.newId)));
            tmp.sort(Comparator.comparingInt(o -> o.newId));
            this.remaps.put((Identifier)name, (ImmutableList<ModRemapping>)ImmutableList.copyOf(tmp));
        });
        this.keys = ImmutableSet.copyOf(this.remaps.keySet());
    }

    public ImmutableSet<Identifier> getRegistries() {
        return this.keys;
    }

    public ImmutableList<ModRemapping> getRemaps(Identifier registry) {
        return this.remaps.get(registry);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public static final class ModRemapping {
        public final Identifier registry;
        public final Identifier key;
        public final int oldId;
        public final int newId;

        private ModRemapping(Identifier registry, Identifier key, int oldId, int newId) {
            this.registry = registry;
            this.key = key;
            this.oldId = oldId;
            this.newId = newId;
        }
    }

    public record IdRemapping(int currId, int newId) {
    }
}

