/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DeferredRegisterData<T>
implements RegistrySetBuilder.RegistryBootstrap<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final String modid;
    private final Lifecycle lifecycle;
    private final Map<RegistryObject<T>, Function<BootstrapContext<T>, ? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Function<BootstrapContext<T>, ? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private boolean beenBuilt = false;

    public static <B> Builder<B> builder(ResourceKey<? extends Registry<B>> registryKey, String modid) {
        DeferredRegisterData.requireNonNull("registryKey", registryKey);
        DeferredRegisterData.requireNonNull("modid", modid);
        return new Builder(registryKey, modid);
    }

    public static <B> DeferredRegisterData<B> create(ResourceKey<? extends Registry<B>> registryKey, String modid) {
        return new Builder(registryKey, modid).build();
    }

    private DeferredRegisterData(Builder<T> builder) {
        this.registryKey = builder.registryKey;
        this.modid = builder.modid;
        this.lifecycle = builder.lifecycle;
    }

    public <I extends T> RegistryObject<I> register(String name) {
        return this.registerInternal(name, null);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> factory) {
        return this.register(name, (BootstrapContext<T> ctx) -> factory.get());
    }

    public <I extends T> RegistryObject<I> register(String name, Function<BootstrapContext<T>, ? extends I> factory) {
        DeferredRegisterData.requireNonNull("factory", factory);
        return this.registerInternal(name, factory);
    }

    private <I extends T> RegistryObject<I> registerInternal(String name, Function<BootstrapContext<T>, ? extends I> factory) {
        if (this.beenBuilt) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after it has been used. You should use this in a static context");
        }
        DeferredRegisterData.requireNonNull("name", name);
        Identifier key = Identifier.fromNamespaceAndPath((String)this.modid, (String)name);
        RegistryObject ret = new RegistryObject(key, this.registryKey, this.modid);
        if (this.entries.containsKey(ret)) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        this.entries.put(ret, factory);
        return ret;
    }

    @NotNull
    public ResourceKey<T> key(@NotNull String path) {
        DeferredRegisterData.requireNonNull("path", path);
        return this.key(Identifier.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    @NotNull
    public ResourceKey<T> key(@NotNull Identifier location) {
        DeferredRegisterData.requireNonNull("location", location);
        return ResourceKey.create(this.getRegistryKey(), (Identifier)location);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull String path) {
        DeferredRegisterData.requireNonNull("path", path);
        return this.createTagKey(Identifier.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull Identifier location) {
        DeferredRegisterData.requireNonNull("location", location);
        return TagKey.create(this.registryKey, (Identifier)location);
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    public ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    @NotNull
    public Identifier getRegistryName() {
        return this.registryKey.identifier();
    }

    private static <T> T requireNonNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    public boolean isDeclared(ResourceKey<T> key) {
        for (Map.Entry<RegistryObject<T>, Function<BootstrapContext<T>, T>> entry : this.entries.entrySet()) {
            if (entry.getKey().getKey() != key) continue;
            return true;
        }
        return false;
    }

    public void run(BootstrapContext<T> context) {
        this.beenBuilt = true;
        HolderGetter lookup = context.lookup(this.registryKey);
        for (Map.Entry<RegistryObject<T>, Function<BootstrapContext<T>, T>> e : this.entries.entrySet()) {
            T value;
            RegistryObject ro = e.getKey();
            if (e.getValue() != null) {
                value = e.getValue().apply(context);
                context.register(ro.getKey(), value, this.lifecycle);
            } else {
                value = lookup.get(ro.getKey()).map(Holder::get).orElse(null);
            }
            ro.updateReference(value, () -> lookup.getOrThrow(ro.getKey()));
        }
    }

    public static class Builder<T> {
        private final ResourceKey<? extends Registry<T>> registryKey;
        private final String modid;
        private Lifecycle lifecycle = Lifecycle.stable();

        private Builder(ResourceKey<? extends Registry<T>> registryKey, String modid) {
            this.registryKey = registryKey;
            this.modid = modid;
        }

        public Builder<T> lifecycle(Lifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public DeferredRegisterData<T> build() {
            return new DeferredRegisterData(this);
        }
    }
}

