/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final String modid;
    private final boolean optionalRegistry;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    @Nullable
    private Supplier<RegistryBuilder<?>> registryFactory;
    @Nullable
    private SetMultimap<TagKey<T>, Supplier<T>> optionalTags;
    private boolean seenRegisterEvent = false;

    public static <B> DeferredRegister<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegister<B>(reg, modid);
    }

    public static <B> DeferredRegister<B> create(RegistryHolder<B> reg, String modid) {
        if (reg instanceof RegistryHolder) {
            RegistryHolder<B> holder = reg;
            return DeferredRegister.create(holder.registryKey, modid);
        }
        throw new IllegalArgumentException("Registry argument was not made by DefferredRegister.makeRegistry. Use another create method. This method will be changed to use the hard type in1 1.20.3, but I don't wanna break everything in 1.20.2 so we have this error");
    }

    public static <B> DeferredRegister<B> create(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegister(key, modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegister(key, modid, true);
    }

    public static <B> DeferredRegister<B> create(Identifier registryName, String modid) {
        return new DeferredRegister(ResourceKey.createRegistryKey((Identifier)registryName), modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(Identifier registryName, String modid) {
        return new DeferredRegister(ResourceKey.createRegistryKey((Identifier)registryName), modid, true);
    }

    private DeferredRegister(ResourceKey<? extends Registry<T>> registryKey, String modid, boolean optionalRegistry) {
        DeferredRegister.requireNonNull("registryKey", registryKey);
        this.registryKey = registryKey;
        this.modid = modid;
        this.optionalRegistry = optionalRegistry;
    }

    private DeferredRegister(IForgeRegistry<T> reg, String modid) {
        this(reg.getRegistryKey(), modid, false);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> factory) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        DeferredRegister.requireNonNull("name", name);
        DeferredRegister.requireNonNull("factory", factory);
        Identifier key = Identifier.fromNamespaceAndPath((String)this.modid, (String)name);
        RegistryObject ret = this.optionalRegistry ? RegistryObject.createOptional(key, this.registryKey, this.modid) : RegistryObject.create(key, this.registryKey, this.modid);
        if (this.entries.putIfAbsent(ret, factory) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    public RegistryHolder<T> makeRegistry(Supplier<RegistryBuilder<T>> sup) {
        return this.makeRegistry(this.registryKey.identifier(), sup);
    }

    @NotNull
    public ResourceKey<T> key(@NotNull String path) {
        DeferredRegister.requireNonNull("path", path);
        return this.key(Identifier.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    @NotNull
    public ResourceKey<T> key(@NotNull Identifier location) {
        DeferredRegister.requireNonNull("location", location);
        return ResourceKey.create(this.getRegistryKey(), (Identifier)location);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull String path) {
        DeferredRegister.requireNonNull("path", path);
        return this.createTagKey(Identifier.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull Identifier location) {
        DeferredRegister.requireNonNull("location", location);
        return TagKey.create(this.registryKey, (Identifier)location);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull String path, @NotNull Set<? extends Supplier<T>> defaults) {
        DeferredRegister.requireNonNull("path", path);
        return this.createOptionalTagKey(Identifier.fromNamespaceAndPath((String)this.modid, (String)path), defaults);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull Identifier location, @NotNull Set<? extends Supplier<T>> defaults) {
        TagKey<T> tagKey = this.createTagKey(location);
        this.addOptionalTagDefaults(tagKey, defaults);
        return tagKey;
    }

    public void addOptionalTagDefaults(@NotNull TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        DeferredRegister.requireNonNull("defaults", defaults);
        if (this.optionalTags == null) {
            this.optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
        }
        this.optionalTags.putAll(name, defaults);
    }

    public void register(BusGroup modBusGroup) {
        EventDispatcher dispatcher = new EventDispatcher();
        RegisterEvent.getBus(modBusGroup).addListener(dispatcher::handleEvent);
        NewRegistryEvent.BUS.addListener(dispatcher::createRegistry);
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    public ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    @NotNull
    public Identifier getRegistryName() {
        return this.registryKey.identifier();
    }

    private RegistryHolder<T> makeRegistry(Identifier registryName, Supplier<RegistryBuilder<T>> sup) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (RegistryManager.ACTIVE.getRegistry(registryName) != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(registryName);
        return new RegistryHolder(this.registryKey);
    }

    private void onFill(IForgeRegistry<?> registry) {
        if (this.optionalTags == null) {
            return;
        }
        ITagManager<?> tagManager = registry.tags();
        if (tagManager == null) {
            throw new IllegalStateException("The forge registry " + String.valueOf(registry.getRegistryName()) + " does not support tags, but optional tags were registered!");
        }
        Multimaps.asMap(this.optionalTags).forEach(tagManager::addOptionalTagDefaults);
    }

    private static <T> T requireNonNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    public static final class RegistryHolder<V>
    implements Supplier<IForgeRegistry<V>> {
        private final ResourceKey<? extends Registry<V>> registryKey;
        private IForgeRegistry<V> registry = null;

        private RegistryHolder(ResourceKey<? extends Registry<V>> registryKey) {
            this.registryKey = registryKey;
        }

        public ResourceKey<? extends Registry<V>> getKey() {
            return this.registryKey;
        }

        @Override
        public IForgeRegistry<V> get() {
            if (this.registry == null) {
                this.registry = RegistryManager.ACTIVE.getRegistry(this.registryKey);
            }
            return this.registry;
        }
    }

    private final class EventDispatcher {
        private EventDispatcher() {
        }

        public void handleEvent(RegisterEvent event) {
            if (event.getRegistryKey().equals(DeferredRegister.this.registryKey)) {
                DeferredRegister.this.seenRegisterEvent = true;
                for (Map.Entry e : DeferredRegister.this.entries.entrySet()) {
                    event.register(DeferredRegister.this.registryKey, e.getKey().getId(), () -> ((Supplier)e.getValue()).get());
                    e.getKey().updateReference(event);
                }
                if (DeferredRegister.this.registryFactory == null && event.getForgeRegistry() != null) {
                    DeferredRegister.this.onFill(event.getForgeRegistry());
                }
            }
        }

        public void createRegistry(NewRegistryEvent event) {
            if (DeferredRegister.this.registryFactory != null) {
                event.create(DeferredRegister.this.registryFactory.get(), DeferredRegister.this::onFill);
            }
        }
    }
}

