/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraftforge.network.Channel;

public class LoginWrapper {
    public static final StreamCodec<FriendlyByteBuf, LoginWrapper> STREAM_CODEC = StreamCodec.ofMember(LoginWrapper::encode, LoginWrapper::new);
    private final Identifier name;
    private FriendlyByteBuf data;
    private final Channel<Object> channel;
    private final Object packet;

    public <MSG> LoginWrapper(Channel<MSG> channel, MSG packet) {
        this(channel.getName(), null, channel, packet);
    }

    private LoginWrapper(FriendlyByteBuf buf) {
        this(buf.readIdentifier(), buf.wrap(buf.readBytes(buf.readVarInt())), null, null);
    }

    private LoginWrapper(Identifier name, FriendlyByteBuf data, Channel<?> channel, Object packet) {
        this.name = name;
        this.data = data;
        this.channel = channel;
        this.packet = packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeIdentifier(this.name);
        if (this.data == null) {
            this.data = buf.wrap(Unpooled.buffer());
            this.channel.encode(this.data, this.packet);
        }
        buf.writeVarInt(this.data.readableBytes());
        buf.writeBytes(this.data.slice());
    }

    public Identifier name() {
        return this.name;
    }

    public FriendlyByteBuf data() {
        return this.data;
    }
}

