/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.function.Consumer;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.Identifier;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ForgePayload;

public class NetworkProtocol<B extends FriendlyByteBuf> {
    public static final NetworkProtocol<RegistryFriendlyByteBuf> PLAY = new NetworkProtocol(ConnectionProtocol.PLAY);
    public static final NetworkProtocol<FriendlyByteBuf> LOGIN = new NetworkProtocol(ConnectionProtocol.LOGIN);
    public static final NetworkProtocol<FriendlyByteBuf> CONFIGURATION = new NetworkProtocol(ConnectionProtocol.CONFIGURATION);
    private final ConnectionProtocol protocol;

    private NetworkProtocol(ConnectionProtocol protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return this.protocol.name();
    }

    public ConnectionProtocol toVanilla() {
        return this.protocol;
    }

    public <T extends PacketListener, MSG> Packet<T> buildPacket(PacketFlow direction, Channel<MSG> channel, MSG packet) {
        return this.buildPacket(direction, channel.getName(packet), buf -> channel.encode((FriendlyByteBuf)buf, packet));
    }

    public <T extends PacketListener> Packet<T> buildPacket(PacketFlow direction, Identifier name, Consumer<B> encoder) {
        ForgePayload payload = ForgePayload.create(name, encoder);
        switch (this.protocol) {
            case PLAY: 
            case CONFIGURATION: {
                if (direction == PacketFlow.CLIENTBOUND) {
                    return new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
                }
                return new ServerboundCustomPayloadPacket((CustomPacketPayload)payload);
            }
            case LOGIN: {
                if (direction == PacketFlow.CLIENTBOUND) {
                    return new ClientboundCustomQueryPacket(0, (CustomQueryPayload)payload);
                }
                return new ServerboundCustomQueryAnswerPacket(0, (CustomQueryAnswerPayload)payload);
            }
        }
        throw new IllegalArgumentException("Invalid protocol, shouldn't be possible as this is a private class..");
    }
}

