/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaInventoryCodeHooks {
    @Nullable
    public static Boolean extractHook(Level level, Hopper dest) {
        IItemHandler handler = VanillaInventoryCodeHooks.getItemHandler(level, dest, Direction.UP).map(Pair::getKey).orElse(null);
        if (handler == null) {
            return null;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.isEmpty()) continue;
            for (int j = 0; j < dest.getContainerSize(); ++j) {
                ItemStack destStack = dest.getItem(j);
                if (!dest.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getMaxStackSize() || !ItemHandlerHelper.canItemStacksStack(extractItem, destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.isEmpty()) {
                    dest.setItem(j, extractItem);
                } else {
                    destStack.grow(1);
                    dest.setItem(j, destStack);
                }
                dest.setChanged();
                return true;
            }
        }
        return false;
    }

    public static boolean dropperInsertHook(Level level, BlockPos pos, DispenserBlockEntity dropper, int slot, @NotNull ItemStack stack) {
        ItemStack dispensedStack;
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)DropperBlock.FACING);
        Optional<Pair<IItemHandler, Object>> handler = VanillaInventoryCodeHooks.getItemHandlerPair(level, pos.relative(direction), direction.getOpposite());
        if (handler.isEmpty()) {
            return true;
        }
        IItemHandler itemHandler = (IItemHandler)handler.get().getKey();
        Object destination = handler.get().getValue();
        ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((BlockEntity)dropper, destination, itemHandler, dispensedStack = stack.copy().split(1));
        if (remainder.isEmpty()) {
            remainder = stack.copy();
            remainder.shrink(1);
        } else {
            remainder = stack.copy();
        }
        dropper.setItem(slot, remainder);
        return false;
    }

    public static boolean insertHook(HopperBlockEntity hopper) {
        Optional<Pair<IItemHandler, Object>> handler = VanillaInventoryCodeHooks.getItemHandler(hopper.getLevel(), (Hopper)hopper, (Direction)hopper.getBlockState().getValue((Property)HopperBlock.FACING));
        if (handler.isEmpty()) {
            return false;
        }
        IItemHandler itemHandler = (IItemHandler)handler.get().getKey();
        Object destination = handler.get().getValue();
        if (VanillaInventoryCodeHooks.isFull(itemHandler)) {
            return false;
        }
        for (int i = 0; i < hopper.getContainerSize(); ++i) {
            if (hopper.getItem(i).isEmpty()) continue;
            ItemStack originalSlotContents = hopper.getItem(i).copy();
            ItemStack insertStack = hopper.removeItem(i, 1);
            ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((BlockEntity)hopper, destination, itemHandler, insertStack);
            if (remainder.isEmpty()) {
                return true;
            }
            hopper.setItem(i, originalSlotContents);
        }
        return false;
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = VanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).isEmpty()) {
            HopperBlockEntity dHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = VanillaInventoryCodeHooks.isEmpty(destInventory);
            if (itemstack.isEmpty()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.EMPTY;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack(itemstack, stack)) {
                int originalSize = stack.getCount();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).getCount();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperBlockEntity && !(dHopper = (HopperBlockEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof HopperBlockEntity) {
                    HopperBlockEntity sHopper = (HopperBlockEntity)source;
                    if (dHopper.getLastUpdateTime() >= sHopper.getLastUpdateTime()) {
                        k = 1;
                    }
                }
                dHopper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, Hopper hopper, Direction hopperFacing) {
        double x = hopper.getLevelX() + (double)hopperFacing.getStepX();
        double y = hopper.getLevelY() + (double)hopperFacing.getStepY();
        double z = hopper.getLevelZ() + (double)hopperFacing.getStepZ();
        return VanillaInventoryCodeHooks.getItemHandler(level, x, y, z, hopperFacing.getOpposite());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Optional<IItemHandler> getItemHandler(Level level, BlockPos pos, @Nullable Direction side) {
        Optional<IItemHandler> handler = VanillaInventoryCodeHooks.getItemHandlerBlock(level, pos, side);
        if (!handler.isPresent()) {
            handler = VanillaInventoryCodeHooks.getItemHandlerEntity(level, pos, side);
        }
        return handler;
    }

    public static Optional<IItemHandler> getItemHandlerEntity(Level level, BlockPos pos, @Nullable Direction side) {
        List entities = level.getEntities((Entity)null, new AABB(pos), e -> e.getCapability(ForgeCapabilities.ITEM_HANDLER, side).isPresent());
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        int rand = level.random.nextInt(entities.size());
        Entity entity = (Entity)entities.get(rand);
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve();
    }

    public static Optional<IItemHandler> getItemHandlerBlock(Level level, BlockPos pos, @Nullable Direction side) {
        if (!level.getBlockState(pos).hasBlockEntity()) {
            return Optional.empty();
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity == null) {
            return Optional.empty();
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve();
    }

    @Deprecated(forRemoval=true, since="1.21.8")
    public static Optional<Pair<IItemHandler, Object>> getItemHandler(Level worldIn, double x, double y, double z, Direction side) {
        int i = Mth.floor((double)x);
        int j = Mth.floor((double)y);
        int k = Mth.floor((double)z);
        return VanillaInventoryCodeHooks.getItemHandlerPair(worldIn, new BlockPos(i, j, k), side);
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandlerPair(Level level, BlockPos pos, Direction side) {
        BlockEntity blockEntity;
        BlockState state = level.getBlockState(pos);
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) != null) {
            return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity));
        }
        return Optional.empty();
    }
}

