/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.network;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.Identifier;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.network.ForgePayload;
import org.jetbrains.annotations.Nullable;

public final class CustomPayloadEvent
extends Record
implements RecordEvent {
    private final Identifier getChannel;
    private final Object getPayloadObject;
    @Nullable
    private final FriendlyByteBuf getPayload;
    private final Context getSource;
    private final int getLoginIndex;
    public static final EventBus<CustomPayloadEvent> BUS = EventBus.create(CustomPayloadEvent.class);

    public CustomPayloadEvent(Identifier channel, Object payload, Context source, int loginIndex) {
        FriendlyByteBuf friendlyByteBuf;
        if (payload instanceof ForgePayload) {
            ForgePayload forge = (ForgePayload)payload;
            friendlyByteBuf = forge.data();
        } else {
            friendlyByteBuf = null;
        }
        this(channel, payload, friendlyByteBuf, source, loginIndex);
    }

    public CustomPayloadEvent(Identifier getChannel, Object getPayloadObject, @Nullable FriendlyByteBuf getPayload, Context getSource, int getLoginIndex) {
        this.getChannel = getChannel;
        this.getPayloadObject = getPayloadObject;
        this.getPayload = getPayload;
        this.getSource = getSource;
        this.getLoginIndex = getLoginIndex;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CustomPayloadEvent.class, "getChannel;getPayloadObject;getPayload;getSource;getLoginIndex", "getChannel", "getPayloadObject", "getPayload", "getSource", "getLoginIndex"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CustomPayloadEvent.class, "getChannel;getPayloadObject;getPayload;getSource;getLoginIndex", "getChannel", "getPayloadObject", "getPayload", "getSource", "getLoginIndex"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CustomPayloadEvent.class, "getChannel;getPayloadObject;getPayload;getSource;getLoginIndex", "getChannel", "getPayloadObject", "getPayload", "getSource", "getLoginIndex"}, this, o);
    }

    public Identifier getChannel() {
        return this.getChannel;
    }

    public Object getPayloadObject() {
        return this.getPayloadObject;
    }

    @Nullable
    public FriendlyByteBuf getPayload() {
        return this.getPayload;
    }

    public Context getSource() {
        return this.getSource;
    }

    public int getLoginIndex() {
        return this.getLoginIndex;
    }

    public static class Context {
        private final Connection connection;
        private final boolean client;
        private boolean packetHandled;

        public Context(Connection connection) {
            this.connection = connection;
            this.client = connection.getReceiving() == PacketFlow.CLIENTBOUND;
        }

        public boolean isClientSide() {
            return this.client;
        }

        public boolean isServerSide() {
            return !this.isClientSide();
        }

        public Connection getConnection() {
            return this.connection;
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.connection.channel().attr(key);
        }

        public void setPacketHandled(boolean packetHandled) {
            this.packetHandled = packetHandled;
        }

        public boolean getPacketHandled() {
            return this.packetHandled;
        }

        public CompletableFuture<Void> enqueueWork(Runnable runnable) {
            BlockableEventLoop<? super TickTask> executor = LogicalSidedProvider.WORKQUEUE.get(this.isClientSide());
            if (!executor.isSameThread()) {
                return executor.submitAsync(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }

        @Nullable
        public ServerPlayer getSender() {
            PacketListener netHandler = this.connection.getPacketListener();
            if (netHandler instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl handler = (ServerGamePacketListenerImpl)netHandler;
                return handler.player;
            }
            return null;
        }
    }
}

