/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.event.level.PistonEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface BlockEvent
permits BlockToolModificationEvent, BreakEvent, CropGrowEvent, EntityPlaceEvent, FarmlandTrampleEvent, FluidPlaceBlockEvent, NeighborNotifyEvent, PortalSpawnEvent, NoteBlockEvent, PistonEvent {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));

    public LevelAccessor getLevel();

    public BlockPos getPos();

    public BlockState getState();

    public static final class BlockToolModificationEvent
    extends MutableEvent
    implements Cancellable,
    BlockEvent {
        public static final CancellableEventBus<BlockToolModificationEvent> BUS = CancellableEventBus.create(BlockToolModificationEvent.class);
        private final LevelAccessor level;
        private final BlockPos pos;
        private final BlockState originalState;
        private final UseOnContext context;
        private final ToolAction toolAction;
        private final boolean simulate;
        private BlockState state;

        public BlockToolModificationEvent(BlockState originalState, @NotNull UseOnContext context, ToolAction toolAction, boolean simulate) {
            this.level = context.getLevel();
            this.pos = context.getClickedPos();
            this.originalState = originalState;
            this.context = context;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = simulate;
        }

        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public BlockState getState() {
            return this.originalState;
        }

        @Nullable
        public Player getPlayer() {
            return this.context.getPlayer();
        }

        public ItemStack getHeldItemStack() {
            return this.context.getItemInHand();
        }

        public ToolAction getToolAction() {
            return this.toolAction;
        }

        public boolean isSimulated() {
            return this.simulate;
        }

        @NotNull
        public UseOnContext getContext() {
            return this.context;
        }

        public void setFinalState(@Nullable BlockState finalState) {
            this.state = finalState;
        }

        public BlockState getFinalState() {
            return this.state;
        }
    }

    public record PortalSpawnEvent(LevelAccessor getLevel, BlockPos getPos, BlockState getState, PortalShape getPortalSize) implements Cancellable,
    BlockEvent,
    RecordEvent
    {
        public static final CancellableEventBus<PortalSpawnEvent> BUS = CancellableEventBus.create(PortalSpawnEvent.class);
    }

    public record FarmlandTrampleEvent(LevelAccessor getLevel, BlockPos getPos, BlockState getState, double getFallDistance, Entity getEntity) implements Cancellable,
    BlockEvent,
    RecordEvent
    {
        public static final CancellableEventBus<FarmlandTrampleEvent> BUS = CancellableEventBus.create(FarmlandTrampleEvent.class);
    }

    public static sealed interface CropGrowEvent
    extends BlockEvent,
    InheritableEvent {
        public static final EventBus<CropGrowEvent> BUS = EventBus.create(CropGrowEvent.class);

        public record Post(LevelAccessor getLevel, BlockPos getPos, BlockState getState, BlockState getOriginalState) implements CropGrowEvent
        {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
        }

        public record Pre(LevelAccessor getLevel, BlockPos getPos, BlockState getState, Result.Holder resultHolder) implements CropGrowEvent,
        HasResult.Record
        {
            public static final EventBus<Pre> BUS = EventBus.create(Pre.class);

            public Pre(Level level, BlockPos pos, BlockState state) {
                this((LevelAccessor)level, pos, state, new Result.Holder());
            }
        }
    }

    public static final class FluidPlaceBlockEvent
    extends MutableEvent
    implements Cancellable,
    BlockEvent {
        public static final CancellableEventBus<FluidPlaceBlockEvent> BUS = CancellableEventBus.create(FluidPlaceBlockEvent.class);
        private final LevelAccessor level;
        private final BlockPos pos;
        private final BlockState state;
        private final BlockPos liquidPos;
        private BlockState newState;
        private final BlockState origState;

        public FluidPlaceBlockEvent(LevelAccessor level, BlockPos pos, BlockPos liquidPos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = level.getBlockState(pos);
        }

        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public BlockState getState() {
            return this.state;
        }

        public BlockPos getLiquidPos() {
            return this.liquidPos;
        }

        public BlockState getNewState() {
            return this.newState;
        }

        public void setNewState(BlockState state) {
            this.newState = state;
        }

        public BlockState getOriginalState() {
            return this.origState;
        }
    }

    public record CreateFluidSourceEvent(Level getLevel, BlockPos getPos, BlockState getState, Result.Holder resultHolder) implements RecordEvent,
    HasResult.Record
    {
        public static final EventBus<CreateFluidSourceEvent> BUS = EventBus.create(CreateFluidSourceEvent.class);

        public CreateFluidSourceEvent(Level level, BlockPos pos, BlockState state) {
            this(level, pos, state, new Result.Holder());
        }
    }

    public record NeighborNotifyEvent(LevelAccessor getLevel, BlockPos getPos, BlockState getState, EnumSet<Direction> getNotifiedSides, boolean getForceRedstoneUpdate) implements Cancellable,
    BlockEvent,
    RecordEvent
    {
        public static final CancellableEventBus<NeighborNotifyEvent> BUS = CancellableEventBus.create(NeighborNotifyEvent.class);
    }

    public static final class EntityMultiPlaceEvent
    extends EntityPlaceEvent
    implements Cancellable {
        public static final CancellableEventBus<EntityMultiPlaceEvent> BUS = CancellableEventBus.create(EntityMultiPlaceEvent.class);
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@NotNull List<BlockSnapshot> blockSnapshots, @NotNull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshots.getFirst(), placedAgainst, entity);
            this.blockSnapshots = List.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created EntityMultiPlaceEvent - [PlacedAgainst: %s ][Entity: %s ]\n", placedAgainst, entity);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    public static sealed class EntityPlaceEvent
    extends MutableEvent
    implements Cancellable,
    BlockEvent
    permits EntityMultiPlaceEvent {
        public static final CancellableEventBus<EntityPlaceEvent> BUS = CancellableEventBus.create(EntityPlaceEvent.class);
        private final LevelAccessor level;
        private final BlockPos pos;
        private final Entity entity;
        private final BlockSnapshot blockSnapshot;
        private final BlockState placedBlock;
        private final BlockState placedAgainst;

        public EntityPlaceEvent(@NotNull BlockSnapshot blockSnapshot, @NotNull BlockState placedAgainst, @Nullable Entity entity) {
            this.level = blockSnapshot.getLevel();
            this.pos = blockSnapshot.getPos();
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof Player) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created EntityPlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][Entity: %s ]\n", this.getPlacedBlock(), placedAgainst, entity);
            }
        }

        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public BlockState getState() {
            return this.placedBlock;
        }

        @Nullable
        public Entity getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public BlockState getPlacedBlock() {
            return this.placedBlock;
        }

        public BlockState getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    public static final class BreakEvent
    extends MutableEvent
    implements Cancellable,
    BlockEvent,
    HasResult {
        public static final CancellableEventBus<BreakEvent> BUS = CancellableEventBus.create(BreakEvent.class);
        private final LevelAccessor level;
        private final BlockPos pos;
        private final BlockState state;
        private final Player player;
        private int exp;
        private Result result;

        public BreakEvent(Level level, BlockPos pos, BlockState state, Player player, Result result) {
            this.level = level;
            this.pos = pos;
            this.state = state;
            this.player = player;
            this.result = result;
            if (state == null || !ForgeHooks.isCorrectToolForDrops(state, player)) {
                this.exp = 0;
            } else {
                Registry lookup = (Registry)level.registryAccess().lookup(Registries.ENCHANTMENT).get();
                int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.FORTUNE), (ItemStack)player.getMainHandItem());
                int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
                this.exp = state.getExpDrop((LevelReader)level, level.random, pos, fortuneLevel, silkTouchLevel);
            }
        }

        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public BlockState getState() {
            return this.state;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.getResult().isDenied() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }
}

