/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public final class PlayerSetSpawnEvent
extends MutableEvent
implements Cancellable,
PlayerEvent {
    public static final CancellableEventBus<PlayerSetSpawnEvent> BUS = CancellableEventBus.create(PlayerSetSpawnEvent.class);
    private final Player player;
    @Nullable
    private final ServerPlayer.RespawnConfig config;
    @Deprecated(forRemoval=true, since="1.21.5")
    private final ResourceKey<Level> spawnLevel;
    @Deprecated(forRemoval=true, since="1.21.5")
    private final boolean forced;
    @Deprecated(forRemoval=true, since="1.21.5")
    @Nullable
    private final BlockPos newSpawn;

    public PlayerSetSpawnEvent(ServerPlayer player, @Nullable ServerPlayer.RespawnConfig config) {
        this.player = player;
        this.config = config;
        if (config == null) {
            this.forced = false;
            this.spawnLevel = Level.OVERWORLD;
            this.newSpawn = null;
        } else {
            this.forced = config.forced();
            this.spawnLevel = config.respawnData().dimension();
            this.newSpawn = config.respawnData().pos();
        }
    }

    @Override
    public Player getEntity() {
        return this.player;
    }

    @Nullable
    public ServerPlayer.RespawnConfig getConfig() {
        return this.config;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public boolean isForced() {
        return this.forced;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    @Nullable
    public BlockPos getNewSpawn() {
        return this.newSpawn;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public ResourceKey<Level> getSpawnLevel() {
        return this.spawnLevel;
    }
}

