/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface MobEffectEvent
extends LivingEvent,
InheritableEvent {
    public static final EventBus<MobEffectEvent> BUS = EventBus.create(MobEffectEvent.class);

    @Nullable
    public MobEffectInstance getEffectInstance();

    public static final class Expired
    extends Record
    implements MobEffectEvent {
        private final LivingEntity getEntity;
        private final MobEffectInstance getEffectInstance;
        public static final EventBus<Expired> BUS = EventBus.create(Expired.class);

        public Expired(LivingEntity getEntity, MobEffectInstance getEffectInstance) {
            this.getEntity = getEntity;
            this.getEffectInstance = getEffectInstance;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Expired.class, "getEntity;getEffectInstance", "getEntity", "getEffectInstance"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Expired.class, "getEntity;getEffectInstance", "getEntity", "getEffectInstance"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Expired.class, "getEntity;getEffectInstance", "getEntity", "getEffectInstance"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }

        @Override
        public MobEffectInstance getEffectInstance() {
            return this.getEffectInstance;
        }
    }

    public static final class Added
    extends Record
    implements MobEffectEvent {
        private final LivingEntity getEntity;
        @Nullable
        private final MobEffectInstance getOldEffectInstance;
        @NotNull
        private final MobEffectInstance getEffectInstance;
        @Nullable
        private final Entity getEffectSource;
        public static final EventBus<Added> BUS = EventBus.create(Added.class);

        public Added(LivingEntity getEntity, @Nullable MobEffectInstance getOldEffectInstance, @NotNull MobEffectInstance getEffectInstance, @Nullable Entity getEffectSource) {
            this.getEntity = getEntity;
            this.getOldEffectInstance = getOldEffectInstance;
            this.getEffectInstance = getEffectInstance;
            this.getEffectSource = getEffectSource;
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return this.getEffectInstance;
        }

        @Nullable
        public MobEffectInstance getOldEffectInstance() {
            return this.getOldEffectInstance;
        }

        @Nullable
        public Entity getEffectSource() {
            return this.getEffectSource;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Added.class, "getEntity;getOldEffectInstance;getEffectInstance;getEffectSource", "getEntity", "getOldEffectInstance", "getEffectInstance", "getEffectSource"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Added.class, "getEntity;getOldEffectInstance;getEffectInstance;getEffectSource", "getEntity", "getOldEffectInstance", "getEffectInstance", "getEffectSource"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Added.class, "getEntity;getOldEffectInstance;getEffectInstance;getEffectSource", "getEntity", "getOldEffectInstance", "getEffectInstance", "getEffectSource"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }
    }

    public static final class Applicable
    implements MobEffectEvent,
    HasResult {
        public static final EventBus<Applicable> BUS = EventBus.create(Applicable.class);
        private final LivingEntity living;
        private final MobEffectInstance effectInstance;
        private Result result = Result.DEFAULT;

        public Applicable(LivingEntity living, @NotNull MobEffectInstance effectInstance) {
            this.living = living;
            this.effectInstance = effectInstance;
        }

        @Override
        public LivingEntity getEntity() {
            return this.living;
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return this.effectInstance;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }

    public static final class Remove
    extends Record
    implements Cancellable,
    MobEffectEvent {
        private final LivingEntity getEntity;
        private final MobEffect getEffect;
        private final MobEffectInstance getEffectInstance;
        public static final CancellableEventBus<Remove> BUS = CancellableEventBus.create(Remove.class);

        public Remove(LivingEntity living, MobEffect effect) {
            this(living, effect, living.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect)));
        }

        public Remove(LivingEntity living, MobEffectInstance effectInstance) {
            this(living, (MobEffect)effectInstance.getEffect().get(), effectInstance);
        }

        public Remove(LivingEntity getEntity, MobEffect getEffect, MobEffectInstance getEffectInstance) {
            this.getEntity = getEntity;
            this.getEffect = getEffect;
            this.getEffectInstance = getEffectInstance;
        }

        public MobEffect getEffect() {
            return this.getEffect;
        }

        @Override
        @Nullable
        public MobEffectInstance getEffectInstance() {
            return this.getEffectInstance;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Remove.class, "getEntity;getEffect;getEffectInstance", "getEntity", "getEffect", "getEffectInstance"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Remove.class, "getEntity;getEffect;getEffectInstance", "getEntity", "getEffect", "getEffectInstance"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Remove.class, "getEntity;getEffect;getEffectInstance", "getEntity", "getEffect", "getEffectInstance"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }
    }
}

