/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.fml.ModLoader;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AddReloadListenerEvent
extends MutableEvent {
    public static final EventBus<AddReloadListenerEvent> BUS = EventBus.create(AddReloadListenerEvent.class);
    private final List<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>();
    private final ReloadableServerResources serverResources;
    private final HolderLookup.Provider registries;

    public AddReloadListenerEvent(ReloadableServerResources serverResources, HolderLookup.Provider registries) {
        this.serverResources = serverResources;
        this.registries = registries;
    }

    public void addListener(PreparableReloadListener listener) {
        this.listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<PreparableReloadListener> getListeners() {
        return List.copyOf(this.listeners);
    }

    public ReloadableServerResources getServerResources() {
        return this.serverResources;
    }

    public ICondition.IContext getConditionContext() {
        return this.serverResources.getConditionContext();
    }

    public HolderLookup.Provider getRegistries() {
        return this.registries;
    }

    private record WrappedStateAwareListener(PreparableReloadListener wrapped) implements PreparableReloadListener
    {
        public CompletableFuture<Void> reload(PreparableReloadListener.SharedState state, Executor backgroundExecutor, PreparableReloadListener.PreparationBarrier stage, Executor gameExecutor) {
            if (ModLoader.isLoadingStateValid()) {
                return this.wrapped.reload(state, backgroundExecutor, stage, gameExecutor);
            }
            return CompletableFuture.completedFuture(null);
        }

        public String getName() {
            return this.wrapped.getName();
        }
    }
}

