/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class BiomeSpecialEffectsBuilder
extends BiomeSpecialEffects.Builder {
    public static BiomeSpecialEffectsBuilder copyOf(BiomeSpecialEffects baseEffects) {
        BiomeSpecialEffectsBuilder ret = BiomeSpecialEffectsBuilder.create().waterColor(baseEffects.waterColor()).grassColorModifier(baseEffects.grassColorModifier());
        if (baseEffects.foliageColorOverride().isPresent()) {
            ret = ret.foliageColorOverride((Integer)baseEffects.foliageColorOverride().get());
        }
        if (baseEffects.dryFoliageColorOverride().isPresent()) {
            ret = ret.dryFoliageColorOverride((Integer)baseEffects.dryFoliageColorOverride().get());
        }
        if (baseEffects.grassColorOverride().isPresent()) {
            ret = ret.grassColorOverride((Integer)baseEffects.grassColorOverride().get());
        }
        return ret;
    }

    public static BiomeSpecialEffectsBuilder create() {
        return new BiomeSpecialEffectsBuilder();
    }

    protected BiomeSpecialEffectsBuilder() {
    }

    public BiomeSpecialEffectsBuilder waterColor(int value) {
        super.waterColor(value);
        return this;
    }

    public OptionalInt waterColor() {
        return this.waterColor;
    }

    public BiomeSpecialEffectsBuilder foliageColorOverride(int value) {
        super.foliageColorOverride(value);
        return this;
    }

    public Optional<Integer> foliageColorOverride() {
        return this.foliageColorOverride;
    }

    public BiomeSpecialEffectsBuilder dryFoliageColorOverride(int value) {
        super.dryFoliageColorOverride(value);
        return this;
    }

    public Optional<Integer> dryFoliageColorOverride() {
        return this.dryFoliageColorOverride;
    }

    public BiomeSpecialEffectsBuilder grassColorOverride(int value) {
        super.grassColorOverride(value);
        return this;
    }

    public Optional<Integer> grassColorOverride() {
        return this.grassColorOverride;
    }

    public BiomeSpecialEffectsBuilder grassColorModifier(BiomeSpecialEffects.GrassColorModifier value) {
        super.grassColorModifier(value);
        return this;
    }

    public BiomeSpecialEffects.GrassColorModifier getGrassColorModifier() {
        return this.grassColorModifier;
    }
}

