/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.CompositeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class ForgeLootTableProvider
extends LootTableProvider {
    private static final String POOLS = "f_79156_";
    private static final String ENTRIES = "f_79023_";
    private static final String CONDITIONS = "f_79024_";
    private static final String CHILDREN = "f_79428_";
    private static final String ENTRY_CONDITION = "f_79636_";
    private static final String TERMS = "f_285609_";

    public ForgeLootTableProvider(PackOutput pack, CompletableFuture<HolderLookup.Provider> lookup) {
        super(pack, Set.of(), VanillaLootTableProvider.create((PackOutput)pack, lookup).getTables(), lookup);
    }

    protected void validate(Registry<LootTable> map, ValidationContext validationcontext, ProblemReporter report) {
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return super.getTables().stream().map(entry -> new LootTableProvider.SubProviderEntry(provider -> this.replaceAndFilterChangesOnly((LootTableSubProvider)entry.provider().apply(provider)), entry.paramSet())).collect(Collectors.toList());
    }

    private LootTableSubProvider replaceAndFilterChangesOnly(LootTableSubProvider subProvider) {
        return newConsumer -> subProvider.generate((Identifier2, builder) -> {
            if (this.findAndReplaceInLootTableBuilder((LootTable.Builder)builder, Items.SHEARS, ToolActions.SHEARS_DIG)) {
                newConsumer.accept(Identifier2, builder);
            }
        });
    }

    private boolean findAndReplaceInLootTableBuilder(LootTable.Builder builder, Item from, ToolAction toolAction) {
        ImmutableList.Builder lootPools = (ImmutableList.Builder)ObfuscationReflectionHelper.getPrivateValue(LootTable.Builder.class, (Object)builder, (String)POOLS);
        boolean found = false;
        if (lootPools == null) {
            throw new IllegalStateException(LootTable.Builder.class.getName() + " is missing field f_79156_");
        }
        for (LootPool lootPool : lootPools.build()) {
            if (!this.findAndReplaceInLootPool(lootPool, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootPool(LootPool lootPool, Item from, ToolAction toolAction) {
        List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)lootPool, (String)ENTRIES);
        ArrayList<LootItemCondition> lootConditions = (ArrayList<LootItemCondition>)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)lootPool, (String)CONDITIONS);
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field f_79023_");
        }
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            if (this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) {
                found = true;
            }
            if (!(lootEntry instanceof CompositeEntryBase) || !this.findAndReplaceInParentedLootEntry((CompositeEntryBase)lootEntry, from, toolAction)) continue;
            found = true;
        }
        if (lootConditions == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field f_79024_");
        }
        lootConditions = new ArrayList<LootItemCondition>(lootConditions);
        ObfuscationReflectionHelper.setPrivateValue(LootPool.class, (Object)lootPool, lootConditions, (String)CONDITIONS);
        for (int i = 0; i < lootConditions.size(); ++i) {
            CompositeLootItemCondition compositeLootItemCondition;
            MatchTool matchTool;
            LootItemCondition lootCondition = (LootItemCondition)lootConditions.get(i);
            if (lootCondition instanceof MatchTool && this.checkMatchTool(matchTool = (MatchTool)lootCondition, from)) {
                lootConditions.set(i, CanToolPerformAction.canToolPerformAction(toolAction).build());
                found = true;
                continue;
            }
            if (lootCondition instanceof InvertedLootItemCondition) {
                CompositeLootItemCondition compositeLootItemCondition2;
                MatchTool matchTool2;
                InvertedLootItemCondition inverted = (InvertedLootItemCondition)lootCondition;
                LootItemCondition invLootCondition = inverted.term();
                if (invLootCondition instanceof MatchTool && this.checkMatchTool(matchTool2 = (MatchTool)invLootCondition, from)) {
                    lootConditions.set(i, InvertedLootItemCondition.invert((LootItemCondition.Builder)CanToolPerformAction.canToolPerformAction(toolAction)).build());
                    found = true;
                    continue;
                }
                if (!(invLootCondition instanceof CompositeLootItemCondition) || !this.findAndReplaceInComposite(compositeLootItemCondition2 = (CompositeLootItemCondition)invLootCondition, from, toolAction)) continue;
                found = true;
                continue;
            }
            if (!(lootCondition instanceof CompositeLootItemCondition) || !this.findAndReplaceInComposite(compositeLootItemCondition = (CompositeLootItemCondition)lootCondition, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(CompositeEntryBase entry, Item from, ToolAction toolAction) {
        List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(CompositeEntryBase.class, (Object)entry, (String)CHILDREN);
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(CompositeEntryBase.class.getName() + " is missing field f_79428_");
        }
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            if (!this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(LootPoolEntryContainer entry, Item from, ToolAction toolAction) {
        ArrayList<LootItemCondition> lootConditions = (ArrayList<LootItemCondition>)ObfuscationReflectionHelper.getPrivateValue(LootPoolEntryContainer.class, (Object)entry, (String)ENTRY_CONDITION);
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(LootPoolEntryContainer.class.getName() + " is missing field f_79636_");
        }
        lootConditions = new ArrayList<LootItemCondition>(lootConditions);
        ObfuscationReflectionHelper.setPrivateValue(LootPoolEntryContainer.class, (Object)entry, lootConditions, (String)ENTRY_CONDITION);
        for (int i = 0; i < lootConditions.size(); ++i) {
            MatchTool matchTool;
            CompositeLootItemCondition composite;
            LootItemCondition condition = (LootItemCondition)lootConditions.get(i);
            if (condition instanceof CompositeLootItemCondition && this.findAndReplaceInComposite(composite = (CompositeLootItemCondition)condition, from, toolAction)) {
                found = true;
                continue;
            }
            if (!(condition instanceof MatchTool) || !this.checkMatchTool(matchTool = (MatchTool)condition, from)) continue;
            lootConditions.set(i, CanToolPerformAction.canToolPerformAction(toolAction).build());
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInComposite(CompositeLootItemCondition alternative, Item from, ToolAction toolAction) {
        ArrayList<LootItemCondition> lootConditions = (ArrayList<LootItemCondition>)ObfuscationReflectionHelper.getPrivateValue(CompositeLootItemCondition.class, (Object)alternative, (String)TERMS);
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(CompositeLootItemCondition.class.getName() + " is missing field f_285609_");
        }
        lootConditions = new ArrayList<LootItemCondition>(lootConditions);
        ObfuscationReflectionHelper.setPrivateValue(CompositeLootItemCondition.class, (Object)alternative, lootConditions, (String)TERMS);
        for (int i = 0; i < lootConditions.size(); ++i) {
            MatchTool matchTool;
            Object e = lootConditions.get(i);
            if (!(e instanceof MatchTool) || !this.checkMatchTool(matchTool = (MatchTool)e, from)) continue;
            lootConditions.set(i, CanToolPerformAction.canToolPerformAction(toolAction).build());
            found = true;
        }
        return found;
    }

    private boolean checkMatchTool(MatchTool lootCondition, Item expected) {
        return lootCondition.predicate().flatMap(ItemPredicate::items).filter(s -> s.contains((Holder)expected.builtInRegistryHolder())).isPresent();
    }
}

