/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeBlockItemTagsProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeItemTagsProvider
extends VanillaItemTagsProvider {
    public ForgeItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider lookupProvider) {
        new ForgeBlockItemTagsProvider(){

            protected TagAppender<Block, Block> tag(TagKey<Block> p_409856_, TagKey<Item> p_406371_) {
                return new VanillaItemTagsProvider.BlockToItemConverter(ForgeItemTagsProvider.this.tag(p_406371_));
            }
        }.run();
        this.tag(Tags.Items.BONES).add((Object)Items.BONE);
        this.tag(Tags.Items.BRICKS).addTags(new TagKey[]{Tags.Items.BRICKS_NORMAL, Tags.Items.BRICKS_NETHER});
        this.tag(Tags.Items.BRICKS_NORMAL).add((Object)Items.BRICK);
        this.tag(Tags.Items.BRICKS_NETHER).add((Object)Items.NETHER_BRICK);
        this.tag(Tags.Items.BUCKETS_EMPTY).add((Object)Items.BUCKET);
        this.tag(Tags.Items.BUCKETS_WATER).add((Object)Items.WATER_BUCKET);
        this.tag(Tags.Items.BUCKETS_LAVA).add((Object)Items.LAVA_BUCKET);
        this.tag(Tags.Items.BUCKETS_MILK).add((Object)Items.MILK_BUCKET);
        this.tag(Tags.Items.BUCKETS_POWDER_SNOW).add((Object)Items.POWDER_SNOW_BUCKET);
        this.tag(Tags.Items.BUCKETS_ENTITY_WATER).add((Object[])new Item[]{Items.AXOLOTL_BUCKET, Items.COD_BUCKET, Items.PUFFERFISH_BUCKET, Items.TADPOLE_BUCKET, Items.TROPICAL_FISH_BUCKET, Items.SALMON_BUCKET});
        this.tag(Tags.Items.BUCKETS).addTags(new TagKey[]{Tags.Items.BUCKETS_EMPTY, Tags.Items.BUCKETS_WATER, Tags.Items.BUCKETS_LAVA, Tags.Items.BUCKETS_MILK, Tags.Items.BUCKETS_POWDER_SNOW, Tags.Items.BUCKETS_ENTITY_WATER});
        this.tag(Tags.Items.CONCRETE_POWDERS).add((Object[])new Item[]{Items.WHITE_CONCRETE_POWDER, Items.ORANGE_CONCRETE_POWDER, Items.MAGENTA_CONCRETE_POWDER, Items.LIGHT_BLUE_CONCRETE_POWDER, Items.YELLOW_CONCRETE_POWDER, Items.LIME_CONCRETE_POWDER, Items.PINK_CONCRETE_POWDER, Items.GRAY_CONCRETE_POWDER, Items.LIGHT_GRAY_CONCRETE_POWDER, Items.CYAN_CONCRETE_POWDER, Items.PURPLE_CONCRETE_POWDER, Items.BLUE_CONCRETE_POWDER, Items.BROWN_CONCRETE_POWDER, Items.GREEN_CONCRETE_POWDER, Items.RED_CONCRETE_POWDER, Items.BLACK_CONCRETE_POWDER});
        this.tag(Tags.Items.CROPS).addTags(new TagKey[]{Tags.Items.CROPS_BEETROOT, Tags.Items.CROPS_CACTUS, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_COCOA_BEAN, Tags.Items.CROPS_MELON, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_PUMPKIN, Tags.Items.CROPS_SUGAR_CANE, Tags.Items.CROPS_WHEAT}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops"));
        this.tag(Tags.Items.CROPS_BEETROOT).add((Object)Items.BEETROOT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops/beetroot"));
        this.tag(Tags.Items.CROPS_CACTUS).add((Object)Items.CACTUS);
        this.tag(Tags.Items.CROPS_CARROT).add((Object)Items.CARROT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops/carrot"));
        this.tag(Tags.Items.CROPS_COCOA_BEAN).add((Object)Items.COCOA_BEANS);
        this.tag(Tags.Items.CROPS_MELON).add((Object)Items.MELON);
        this.tag(Tags.Items.CROPS_NETHER_WART).add((Object)Items.NETHER_WART).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops/nether_wart"));
        this.tag(Tags.Items.CROPS_POTATO).add((Object)Items.POTATO).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops/potato"));
        this.tag(Tags.Items.CROPS_PUMPKIN).add((Object)Items.PUMPKIN);
        this.tag(Tags.Items.CROPS_SUGAR_CANE).add((Object)Items.SUGAR_CANE);
        this.tag(Tags.Items.CROPS_WHEAT).add((Object)Items.WHEAT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("crops/wheat"));
        this.addColored(Tags.Items.DYED, "{color}_banner");
        this.addColored(Tags.Items.DYED, "{color}_bed");
        this.addColored(Tags.Items.DYED, "{color}_candle");
        this.addColored(Tags.Items.DYED, "{color}_carpet");
        this.addColored(Tags.Items.DYED, "{color}_concrete");
        this.addColored(Tags.Items.DYED, "{color}_concrete_powder");
        this.addColored(Tags.Items.DYED, "{color}_glazed_terracotta");
        this.addColored(Tags.Items.DYED, "{color}_shulker_box");
        this.addColored(Tags.Items.DYED, "{color}_stained_glass");
        this.addColored(Tags.Items.DYED, "{color}_stained_glass_pane");
        this.addColored(Tags.Items.DYED, "{color}_terracotta");
        this.addColored(Tags.Items.DYED, "{color}_wool");
        ForgeItemTagsProvider.addColoredTags(arg_0 -> ForgeItemTagsProvider.lambda$addTags$0(this.tag(Tags.Items.DYED), arg_0), Tags.Items.DYED);
        this.tag(Tags.Items.DUSTS).addTags(new TagKey[]{Tags.Items.DUSTS_GLOWSTONE, Tags.Items.DUSTS_REDSTONE});
        this.tag(Tags.Items.DUSTS_GLOWSTONE).add((Object)Items.GLOWSTONE_DUST).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("dusts/glowstone"));
        this.tag(Tags.Items.DUSTS_REDSTONE).add((Object)Items.REDSTONE).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("dusts/redstone"));
        this.addColored(Tags.Items.DYES, "{color}_dye");
        ForgeItemTagsProvider.addColoredTags(arg_0 -> ForgeItemTagsProvider.lambda$addTags$1(this.tag(Tags.Items.DYES), arg_0), Tags.Items.DYES);
        this.tag(Tags.Items.EGGS).add((Object)Items.EGG);
        this.tag(Tags.Items.ENCHANTING_FUELS).addTag(Tags.Items.GEMS_LAPIS);
        this.tag(Tags.Items.ENDER_PEARLS).add((Object)Items.ENDER_PEARL).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("ender_pearls"));
        this.tag(Tags.Items.FEATHERS).add((Object)Items.FEATHER).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("feathers"));
        this.tag(Tags.Items.FERTILIZERS).add((Object)Items.BONE_MEAL);
        this.tag(Tags.Items.FOODS_FRUIT).add((Object[])new Item[]{Items.APPLE, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE, Items.CHORUS_FRUIT, Items.MELON_SLICE});
        this.tag(Tags.Items.FOODS_VEGETABLE).add((Object[])new Item[]{Items.CARROT, Items.GOLDEN_CARROT, Items.POTATO, Items.BEETROOT});
        this.tag(Tags.Items.FOODS_BERRY).add((Object[])new Item[]{Items.SWEET_BERRIES, Items.GLOW_BERRIES});
        this.tag(Tags.Items.FOODS_BREAD).add((Object)Items.BREAD);
        this.tag(Tags.Items.FOODS_COOKIE).add((Object)Items.COOKIE);
        this.tag(Tags.Items.FOODS_RAW_MEAT).add((Object[])new Item[]{Items.BEEF, Items.PORKCHOP, Items.CHICKEN, Items.RABBIT, Items.MUTTON});
        this.tag(Tags.Items.FOODS_RAW_FISH).add((Object[])new Item[]{Items.COD, Items.SALMON, Items.TROPICAL_FISH, Items.PUFFERFISH});
        this.tag(Tags.Items.FOODS_COOKED_MEAT).add((Object[])new Item[]{Items.COOKED_BEEF, Items.COOKED_PORKCHOP, Items.COOKED_CHICKEN, Items.COOKED_RABBIT, Items.COOKED_MUTTON});
        this.tag(Tags.Items.FOODS_COOKED_FISH).add((Object[])new Item[]{Items.COOKED_COD, Items.COOKED_SALMON});
        this.tag(Tags.Items.FOODS_SOUP).add((Object[])new Item[]{Items.BEETROOT_SOUP, Items.MUSHROOM_STEW, Items.RABBIT_STEW, Items.SUSPICIOUS_STEW});
        this.tag(Tags.Items.FOODS_CANDY);
        this.tag(Tags.Items.FOODS_PIE).add((Object)Items.PUMPKIN_PIE).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("foods/pie"));
        this.tag(Tags.Items.FOODS_EDIBLE_WHEN_PLACED).add((Object)Items.CAKE);
        this.tag(Tags.Items.FOODS_FOOD_POISONING).add((Object[])new Item[]{Items.POISONOUS_POTATO, Items.PUFFERFISH, Items.SPIDER_EYE, Items.CHICKEN, Items.ROTTEN_FLESH});
        this.tag(Tags.Items.FOODS_GOLDEN).add((Object[])new Item[]{Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE, Items.GOLDEN_CARROT});
        this.tag(Tags.Items.FOODS).add((Object[])new Item[]{Items.BAKED_POTATO, Items.HONEY_BOTTLE, Items.OMINOUS_BOTTLE, Items.DRIED_KELP}).addTags(new TagKey[]{Tags.Items.FOODS_FRUIT, Tags.Items.FOODS_VEGETABLE, Tags.Items.FOODS_BERRY, Tags.Items.FOODS_BREAD, Tags.Items.FOODS_COOKIE, Tags.Items.FOODS_RAW_MEAT, Tags.Items.FOODS_RAW_FISH, Tags.Items.FOODS_COOKED_MEAT, Tags.Items.FOODS_COOKED_FISH, Tags.Items.FOODS_SOUP, Tags.Items.FOODS_CANDY, Tags.Items.FOODS_PIE, Tags.Items.FOODS_GOLDEN, Tags.Items.FOODS_EDIBLE_WHEN_PLACED, Tags.Items.FOODS_FOOD_POISONING});
        this.tag(Tags.Items.ANIMAL_FOODS).addTags(new TagKey[]{ItemTags.ARMADILLO_FOOD, ItemTags.AXOLOTL_FOOD, ItemTags.BEE_FOOD, ItemTags.CAMEL_FOOD, ItemTags.CAT_FOOD, ItemTags.CHICKEN_FOOD, ItemTags.COW_FOOD, ItemTags.FOX_FOOD, ItemTags.FROG_FOOD, ItemTags.GOAT_FOOD, ItemTags.HOGLIN_FOOD, ItemTags.HORSE_FOOD, ItemTags.LLAMA_FOOD, ItemTags.OCELOT_FOOD, ItemTags.PANDA_FOOD, ItemTags.PARROT_FOOD, ItemTags.PIG_FOOD, ItemTags.PIGLIN_FOOD, ItemTags.RABBIT_FOOD, ItemTags.SHEEP_FOOD, ItemTags.SNIFFER_FOOD, ItemTags.STRIDER_FOOD, ItemTags.TURTLE_FOOD, ItemTags.WOLF_FOOD});
        this.tag(Tags.Items.GEMS).addTags(new TagKey[]{Tags.Items.GEMS_AMETHYST, Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_EMERALD, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_PRISMARINE, Tags.Items.GEMS_QUARTZ}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems"));
        this.tag(Tags.Items.GEMS_AMETHYST).add((Object)Items.AMETHYST_SHARD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/amethyst"));
        this.tag(Tags.Items.GEMS_DIAMOND).add((Object)Items.DIAMOND).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/diamond"));
        this.tag(Tags.Items.GEMS_EMERALD).add((Object)Items.EMERALD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/emerald"));
        this.tag(Tags.Items.GEMS_LAPIS).add((Object)Items.LAPIS_LAZULI).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/lapis"));
        this.tag(Tags.Items.GEMS_PRISMARINE).add((Object)Items.PRISMARINE_CRYSTALS).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/prismarine"));
        this.tag(Tags.Items.GEMS_QUARTZ).add((Object)Items.QUARTZ).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("gems/quartz"));
        this.tag(Tags.Items.GUNPOWDER).add((Object)Items.GUNPOWDER);
        this.tag(Tags.Items.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_NETHERITE});
        this.tag(Tags.Items.INGOTS_COPPER).add((Object)Items.COPPER_INGOT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("ingots/copper"));
        this.tag(Tags.Items.INGOTS_GOLD).add((Object)Items.GOLD_INGOT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("ingots/gold"));
        this.tag(Tags.Items.INGOTS_IRON).add((Object)Items.IRON_INGOT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("ingots/iron"));
        this.tag(Tags.Items.INGOTS_NETHERITE).add((Object)Items.NETHERITE_INGOT).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("ingots/netherite"));
        this.tag(Tags.Items.LEATHERS).add((Object)Items.LEATHER).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("leather"));
        this.tag(Tags.Items.MUSHROOMS).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("mushrooms"));
        this.tag(Tags.Items.MUSIC_DISCS).add((Object[])new Item[]{Items.MUSIC_DISC_13, Items.MUSIC_DISC_CAT, Items.MUSIC_DISC_BLOCKS, Items.MUSIC_DISC_CHIRP, Items.MUSIC_DISC_FAR, Items.MUSIC_DISC_MALL, Items.MUSIC_DISC_MELLOHI, Items.MUSIC_DISC_STAL, Items.MUSIC_DISC_STRAD, Items.MUSIC_DISC_WARD, Items.MUSIC_DISC_11, Items.MUSIC_DISC_WAIT, Items.MUSIC_DISC_OTHERSIDE, Items.MUSIC_DISC_5, Items.MUSIC_DISC_PIGSTEP, Items.MUSIC_DISC_RELIC, Items.MUSIC_DISC_CREATOR, Items.MUSIC_DISC_CREATOR_MUSIC_BOX, Items.MUSIC_DISC_PRECIPICE});
        this.tag(Tags.Items.NETHER_STARS).add((Object)Items.NETHER_STAR).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("nether_stars"));
        this.tag(Tags.Items.NUGGETS).addTags(new TagKey[]{Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_IRON, Tags.Items.NUGGETS_COPPER}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("nuggets"));
        this.tag(Tags.Items.NUGGETS_COPPER).add((Object)Items.COPPER_NUGGET);
        this.tag(Tags.Items.NUGGETS_IRON).add((Object)Items.IRON_NUGGET).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("nuggets/iron"));
        this.tag(Tags.Items.NUGGETS_GOLD).add((Object)Items.GOLD_NUGGET).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("nuggets/gold"));
        this.tag(Tags.Items.RAW_MATERIALS).addTags(new TagKey[]{Tags.Items.RAW_MATERIALS_COPPER, Tags.Items.RAW_MATERIALS_GOLD, Tags.Items.RAW_MATERIALS_IRON}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials"));
        this.tag(Tags.Items.RAW_MATERIALS_COPPER).add((Object)Items.RAW_COPPER).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/copper"));
        this.tag(Tags.Items.RAW_MATERIALS_GOLD).add((Object)Items.RAW_GOLD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/gold"));
        this.tag(Tags.Items.RAW_MATERIALS_IRON).add((Object)Items.RAW_IRON).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/iron"));
        this.tag(Tags.Items.RODS).addTags(new TagKey[]{Tags.Items.RODS_WOODEN, Tags.Items.RODS_BLAZE, Tags.Items.RODS_BREEZE}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("rods"));
        this.tag(Tags.Items.RODS_BLAZE).add((Object)Items.BLAZE_ROD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("rods/blaze"));
        this.tag(Tags.Items.RODS_BREEZE).add((Object)Items.BREEZE_ROD);
        this.tag(Tags.Items.RODS_WOODEN).add((Object)Items.STICK).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("rods/wooden"));
        this.tag(Tags.Items.SEEDS).addTags(new TagKey[]{Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_PUMPKIN, Tags.Items.SEEDS_WHEAT});
        this.tag(Tags.Items.SEEDS_BEETROOT).add((Object)Items.BEETROOT_SEEDS);
        this.tag(Tags.Items.SEEDS_MELON).add((Object)Items.MELON_SEEDS);
        this.tag(Tags.Items.SEEDS_PUMPKIN).add((Object)Items.PUMPKIN_SEEDS);
        this.tag(Tags.Items.SEEDS_WHEAT).add((Object)Items.WHEAT_SEEDS);
        this.tag(Tags.Items.SLIME_BALLS).add((Object)Items.SLIME_BALL).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("slimeballs"));
        this.tag(Tags.Items.SHULKER_BOXES).add((Object[])new Item[]{Items.SHULKER_BOX, Items.WHITE_SHULKER_BOX, Items.ORANGE_SHULKER_BOX, Items.MAGENTA_SHULKER_BOX, Items.LIGHT_BLUE_SHULKER_BOX, Items.YELLOW_SHULKER_BOX, Items.LIME_SHULKER_BOX, Items.PINK_SHULKER_BOX, Items.GRAY_SHULKER_BOX, Items.LIGHT_GRAY_SHULKER_BOX, Items.CYAN_SHULKER_BOX, Items.PURPLE_SHULKER_BOX, Items.BLUE_SHULKER_BOX, Items.BROWN_SHULKER_BOX, Items.GREEN_SHULKER_BOX, Items.RED_SHULKER_BOX, Items.BLACK_SHULKER_BOX});
        this.tag(Tags.Items.STRINGS).add((Object)Items.STRING).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("strings"));
        this.tag(Tags.Items.VILLAGER_JOB_SITES).add((Object[])new Item[]{Items.BARREL, Items.BLAST_FURNACE, Items.BREWING_STAND, Items.CARTOGRAPHY_TABLE, Items.CAULDRON, Items.COMPOSTER, Items.FLETCHING_TABLE, Items.GRINDSTONE, Items.LECTERN, Items.LOOM, Items.SMITHING_TABLE, Items.SMOKER, Items.STONECUTTER});
        this.tag(Tags.Items.TOOLS_SHIELD).add((Object)Items.SHIELD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("tools/shields"));
        this.tag(Tags.Items.TOOLS_BOW).add((Object)Items.BOW).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("tools/bows"));
        this.tag(Tags.Items.TOOLS_BRUSH).add((Object)Items.BRUSH);
        this.tag(Tags.Items.TOOLS_CROSSBOW).add((Object)Items.CROSSBOW).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("tools/crossbows"));
        this.tag(Tags.Items.TOOLS_FISHING_ROD).add((Object)Items.FISHING_ROD).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("tools/fishing_rods"));
        this.tag(Tags.Items.TOOLS_SHEAR).add((Object)Items.SHEARS).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("tools/shears"));
        this.tag(Tags.Items.TOOLS_SPEAR).add((Object)Items.TRIDENT);
        this.tag(Tags.Items.TOOLS_MACE).add((Object)Items.MACE);
        this.tag(Tags.Items.TOOLS_IGNITER).add((Object)Items.FLINT_AND_STEEL);
        this.tag(Tags.Items.MINING_TOOL_TOOLS).add((Object[])new Item[]{Items.WOODEN_PICKAXE, Items.STONE_PICKAXE, Items.IRON_PICKAXE, Items.GOLDEN_PICKAXE, Items.DIAMOND_PICKAXE, Items.NETHERITE_PICKAXE});
        this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object[])new Item[]{Items.MACE, Items.TRIDENT, Items.WOODEN_SWORD, Items.STONE_SWORD, Items.GOLDEN_SWORD, Items.IRON_SWORD, Items.DIAMOND_SWORD, Items.NETHERITE_SWORD, Items.WOODEN_AXE, Items.STONE_AXE, Items.GOLDEN_AXE, Items.IRON_AXE, Items.DIAMOND_AXE, Items.NETHERITE_AXE});
        this.tag(Tags.Items.RANGED_WEAPON_TOOLS).add((Object[])new Item[]{Items.BOW, Items.CROSSBOW, Items.TRIDENT});
        this.tag(Tags.Items.TOOLS).addTags(new TagKey[]{ItemTags.AXES, ItemTags.HOES, ItemTags.PICKAXES, ItemTags.SHOVELS, ItemTags.SWORDS}).addTags(new TagKey[]{Tags.Items.TOOLS_BOW, Tags.Items.TOOLS_BRUSH, Tags.Items.TOOLS_CROSSBOW, Tags.Items.TOOLS_FISHING_ROD, Tags.Items.TOOLS_SHEAR, Tags.Items.TOOLS_IGNITER, Tags.Items.TOOLS_SHIELD, Tags.Items.TOOLS_SPEAR, Tags.Items.TOOLS_MACE, Tags.Items.MINING_TOOL_TOOLS, Tags.Items.MELEE_WEAPON_TOOLS, Tags.Items.RANGED_WEAPON_TOOLS});
        this.tag(Tags.Items.ARMORS).addTags(new TagKey[]{ItemTags.HEAD_ARMOR, ItemTags.CHEST_ARMOR, ItemTags.LEG_ARMOR, ItemTags.FOOT_ARMOR}).addOptionalTag(ForgeItemTagsProvider.forgeItemTagKey("armors"));
        this.tag(Tags.Items.ENCHANTABLES).addTags(new TagKey[]{ItemTags.ARMOR_ENCHANTABLE, ItemTags.EQUIPPABLE_ENCHANTABLE, ItemTags.WEAPON_ENCHANTABLE, ItemTags.SHARP_WEAPON_ENCHANTABLE, ItemTags.MINING_ENCHANTABLE, ItemTags.MINING_LOOT_ENCHANTABLE, ItemTags.FISHING_ENCHANTABLE, ItemTags.TRIDENT_ENCHANTABLE, ItemTags.BOW_ENCHANTABLE, ItemTags.CROSSBOW_ENCHANTABLE, ItemTags.MACE_ENCHANTABLE, ItemTags.FIRE_ASPECT_ENCHANTABLE, ItemTags.DURABILITY_ENCHANTABLE, ItemTags.VANISHING_ENCHANTABLE});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("bones")).add((Object)Items.BONE);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("crops/beetroot"), ForgeItemTagsProvider.forgeItemTagKey("crops/carrot"), ForgeItemTagsProvider.forgeItemTagKey("crops/nether_wart"), ForgeItemTagsProvider.forgeItemTagKey("crops/potato"), ForgeItemTagsProvider.forgeItemTagKey("crops/wheat")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops/beetroot")).add((Object)Items.BEETROOT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops/carrot")).add((Object)Items.CARROT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops/nether_wart")).add((Object)Items.NETHER_WART);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops/potato")).add((Object)Items.POTATO);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("crops/wheat")).add((Object)Items.WHEAT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("foods/pie")).add((Object)Items.PUMPKIN_PIE);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("dusts")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("dusts/glowstone"), Tags.Items.DUSTS_PRISMARINE, ForgeItemTagsProvider.forgeItemTagKey("dusts/redstone")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("dusts/glowstone")).add((Object)Items.GLOWSTONE_DUST);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("dusts/prismarine")).add((Object)Items.PRISMARINE_SHARD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("dusts/redstone")).add((Object)Items.REDSTONE);
        this.addColored(arg_0 -> ForgeItemTagsProvider.lambda$addTags$2(this.tag(ForgeItemTagsProvider.forgeItemTagKey("dyes")), arg_0), ForgeItemTagsProvider.forgeItemTagKey("dyes"), "{color}_dye");
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("eggs")).add((Object)Items.EGG);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("enchanting_fuels")).addTag(ForgeItemTagsProvider.forgeItemTagKey("gems/lapis"));
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ender_pearls")).add((Object)Items.ENDER_PEARL);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("feathers")).add((Object)Items.FEATHER);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("gems/amethyst"), ForgeItemTagsProvider.forgeItemTagKey("gems/diamond"), ForgeItemTagsProvider.forgeItemTagKey("gems/emerald"), ForgeItemTagsProvider.forgeItemTagKey("gems/lapis"), ForgeItemTagsProvider.forgeItemTagKey("gems/prismarine"), ForgeItemTagsProvider.forgeItemTagKey("gems/quartz")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/amethyst")).add((Object)Items.AMETHYST_SHARD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/diamond")).add((Object)Items.DIAMOND);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/emerald")).add((Object)Items.EMERALD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/lapis")).add((Object)Items.LAPIS_LAZULI);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/prismarine")).add((Object)Items.PRISMARINE_CRYSTALS);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gems/quartz")).add((Object)Items.QUARTZ);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("gunpowder")).add((Object)Items.GUNPOWDER);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("heads")).add((Object[])new Item[]{Items.CREEPER_HEAD, Items.DRAGON_HEAD, Items.PLAYER_HEAD, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.ZOMBIE_HEAD});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("ingots/brick"), ForgeItemTagsProvider.forgeItemTagKey("ingots/copper"), ForgeItemTagsProvider.forgeItemTagKey("ingots/gold"), ForgeItemTagsProvider.forgeItemTagKey("ingots/iron"), ForgeItemTagsProvider.forgeItemTagKey("ingots/netherite"), ForgeItemTagsProvider.forgeItemTagKey("ingots/nether_brick")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/brick")).add((Object)Items.BRICK);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/copper")).add((Object)Items.COPPER_INGOT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/gold")).add((Object)Items.GOLD_INGOT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/iron")).add((Object)Items.IRON_INGOT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/netherite")).add((Object)Items.NETHERITE_INGOT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("ingots/nether_brick")).add((Object)Items.NETHER_BRICK);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("leather")).add((Object)Items.LEATHER);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("mushrooms")).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("nether_stars")).add((Object)Items.NETHER_STAR);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("nuggets")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("nuggets/iron"), ForgeItemTagsProvider.forgeItemTagKey("nuggets/gold")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("nuggets/iron")).add((Object)Items.IRON_NUGGET);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("nuggets/gold")).add((Object)Items.GOLD_NUGGET);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("raw_materials/copper"), ForgeItemTagsProvider.forgeItemTagKey("raw_materials/gold"), ForgeItemTagsProvider.forgeItemTagKey("raw_materials/iron")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/copper")).add((Object)Items.RAW_COPPER);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/gold")).add((Object)Items.RAW_GOLD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("raw_materials/iron")).add((Object)Items.RAW_IRON);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("rods")).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("rods/blaze"), ForgeItemTagsProvider.forgeItemTagKey("rods/wooden")});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("rods/blaze")).add((Object)Items.BLAZE_ROD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("rods/wooden")).add((Object)Items.STICK);
        this.tag(Tags.Items.SEEDS).addTags(new TagKey[]{Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_PUMPKIN, Tags.Items.SEEDS_WHEAT});
        this.tag(Tags.Items.SEEDS_BEETROOT).add((Object)Items.BEETROOT_SEEDS);
        this.tag(Tags.Items.SEEDS_MELON).add((Object)Items.MELON_SEEDS);
        this.tag(Tags.Items.SEEDS_PUMPKIN).add((Object)Items.PUMPKIN_SEEDS);
        this.tag(Tags.Items.SEEDS_WHEAT).add((Object)Items.WHEAT_SEEDS);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("shears")).add((Object)Items.SHEARS);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("slimeballs")).add((Object)Items.SLIME_BALL);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("string")).add((Object)Items.STRING);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools/shields")).add((Object)Items.SHIELD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools/bows")).add((Object)Items.BOW);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools/crossbows")).add((Object)Items.CROSSBOW);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools/fishing_rods")).add((Object)Items.FISHING_ROD);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools/tridents")).add((Object)Items.TRIDENT);
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("tools")).addTags(new TagKey[]{ItemTags.SWORDS, ItemTags.AXES, ItemTags.PICKAXES, ItemTags.SHOVELS, ItemTags.HOES}).addTags(new TagKey[]{ForgeItemTagsProvider.forgeItemTagKey("tools/shields"), ForgeItemTagsProvider.forgeItemTagKey("tools/bows"), ForgeItemTagsProvider.forgeItemTagKey("tools/crossbows"), ForgeItemTagsProvider.forgeItemTagKey("tools/fishing_rods"), ForgeItemTagsProvider.forgeItemTagKey("tools/tridents")});
        this.tag(Tags.Items.ARMORS_HELMETS).add((Object[])new Item[]{Items.LEATHER_HELMET, Items.TURTLE_HELMET, Items.CHAINMAIL_HELMET, Items.IRON_HELMET, Items.GOLDEN_HELMET, Items.DIAMOND_HELMET, Items.NETHERITE_HELMET});
        this.tag(Tags.Items.ARMORS_CHESTPLATES).add((Object[])new Item[]{Items.LEATHER_CHESTPLATE, Items.CHAINMAIL_CHESTPLATE, Items.IRON_CHESTPLATE, Items.GOLDEN_CHESTPLATE, Items.DIAMOND_CHESTPLATE, Items.NETHERITE_CHESTPLATE});
        this.tag(Tags.Items.ARMORS_LEGGINGS).add((Object[])new Item[]{Items.LEATHER_LEGGINGS, Items.CHAINMAIL_LEGGINGS, Items.IRON_LEGGINGS, Items.GOLDEN_LEGGINGS, Items.DIAMOND_LEGGINGS, Items.NETHERITE_LEGGINGS});
        this.tag(Tags.Items.ARMORS_BOOTS).add((Object[])new Item[]{Items.LEATHER_BOOTS, Items.CHAINMAIL_BOOTS, Items.IRON_BOOTS, Items.GOLDEN_BOOTS, Items.DIAMOND_BOOTS, Items.NETHERITE_BOOTS});
        this.tag(ForgeItemTagsProvider.forgeItemTagKey("armors")).addTags(new TagKey[]{Tags.Items.ARMORS_HELMETS, Tags.Items.ARMORS_CHESTPLATES, Tags.Items.ARMORS_LEGGINGS, Tags.Items.ARMORS_BOOTS});
    }

    private void addColored(TagKey<Item> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            Identifier key = Identifier.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey<Item> tag = ForgeItemTagsProvider.getForgeItemTag(prefix + color.getName());
            Item item = (Item)BuiltInRegistries.ITEM.getValue(key);
            if (item == null || item == Items.AIR) {
                throw new IllegalStateException("Unknown vanilla item: " + String.valueOf(key));
            }
            this.tag(tag).add((Object)item);
        }
    }

    private void addColored(Consumer<TagKey<Item>> consumer, TagKey<Item> group, String pattern) {
        String prefix = group.location().getPath() + "/";
        for (DyeColor color : DyeColor.values()) {
            Identifier key = Identifier.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey<Item> tag = ForgeItemTagsProvider.forgeItemTagKey(prefix + color.getName());
            Item item = ForgeRegistries.ITEMS.getValue(key);
            if (item == null || item == Items.AIR) {
                throw new IllegalStateException("Unknown vanilla item: " + key.toString());
            }
            this.tag(tag).add((Object)item);
            consumer.accept(tag);
        }
    }

    private static void addColoredTags(Consumer<TagKey<Item>> consumer, TagKey<Item> group) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            TagKey<Item> tag = ForgeItemTagsProvider.getForgeItemTag(prefix + color.getName());
            consumer.accept(tag);
        }
    }

    private static TagKey<Item> getForgeItemTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Items.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Items.class.getName() + " is missing tag name: " + name);
        }
    }

    private static Identifier forgeRl(String path) {
        return Identifier.fromNamespaceAndPath((String)"forge", (String)path);
    }

    private static TagKey<Item> forgeItemTagKey(String path) {
        return ItemTags.create((Identifier)ForgeItemTagsProvider.forgeRl(path));
    }

    public String getName() {
        return "Forge Item Tags";
    }

    private static /* synthetic */ void lambda$addTags$2(TagAppender rec$, TagKey xva$0) {
        rec$.addTags(new TagKey[]{xva$0});
    }

    private static /* synthetic */ void lambda$addTags$1(TagAppender rec$, TagKey xva$0) {
        rec$.addTags(new TagKey[]{xva$0});
    }

    private static /* synthetic */ void lambda$addTags$0(TagAppender rec$, TagKey xva$0) {
        rec$.addTags(new TagKey[]{xva$0});
    }
}

