/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeBlockItemTagsProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ForgeBlockTagsProvider
extends VanillaBlockTagsProvider {
    public ForgeBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider p_256380_) {
        new ForgeBlockItemTagsProvider(){

            protected TagAppender<Block, Block> tag(TagKey<Block> p_406922_, TagKey<Item> p_408417_) {
                return ForgeBlockTagsProvider.this.tag(p_406922_);
            }
        }.run();
        this.tag(Tags.Blocks.CHORUS_ADDITIONALLY_GROWS_ON).addTag(Tags.Blocks.END_STONES);
        this.addColored(Tags.Blocks.DYED, "{color}_banner");
        this.addColored(Tags.Blocks.DYED, "{color}_bed");
        this.addColored(Tags.Blocks.DYED, "{color}_candle");
        this.addColored(Tags.Blocks.DYED, "{color}_carpet");
        this.addColored(Tags.Blocks.DYED, "{color}_concrete");
        this.addColored(Tags.Blocks.DYED, "{color}_concrete_powder");
        this.addColored(Tags.Blocks.DYED, "{color}_glazed_terracotta");
        this.addColored(Tags.Blocks.DYED, "{color}_shulker_box");
        this.addColored(Tags.Blocks.DYED, "{color}_stained_glass");
        this.addColored(Tags.Blocks.DYED, "{color}_stained_glass_pane");
        this.addColored(Tags.Blocks.DYED, "{color}_terracotta");
        this.addColored(Tags.Blocks.DYED, "{color}_wall_banner");
        this.addColored(Tags.Blocks.DYED, "{color}_wool");
        ForgeBlockTagsProvider.addColoredTags(arg_0 -> ((TagAppender)this.tag(Tags.Blocks.DYED)).addTag(arg_0), Tags.Blocks.DYED);
        this.tag(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST);
        this.tag(Tags.Blocks.SKULLS).add((Object[])new Block[]{Blocks.SKELETON_SKULL, Blocks.SKELETON_WALL_SKULL, Blocks.WITHER_SKELETON_SKULL, Blocks.WITHER_SKELETON_WALL_SKULL, Blocks.PLAYER_HEAD, Blocks.PLAYER_WALL_HEAD, Blocks.ZOMBIE_HEAD, Blocks.ZOMBIE_WALL_HEAD, Blocks.CREEPER_HEAD, Blocks.CREEPER_WALL_HEAD, Blocks.PIGLIN_HEAD, Blocks.PIGLIN_WALL_HEAD, Blocks.DRAGON_HEAD, Blocks.DRAGON_WALL_HEAD});
        this.tag(Tags.Blocks.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED);
        this.tag(Tags.Blocks.VILLAGER_JOB_SITES).add((Object[])new Block[]{Blocks.BARREL, Blocks.BLAST_FURNACE, Blocks.BREWING_STAND, Blocks.CARTOGRAPHY_TABLE, Blocks.CAULDRON, Blocks.WATER_CAULDRON, Blocks.LAVA_CAULDRON, Blocks.POWDER_SNOW_CAULDRON, Blocks.COMPOSTER, Blocks.FLETCHING_TABLE, Blocks.GRINDSTONE, Blocks.LECTERN, Blocks.LOOM, Blocks.SMITHING_TABLE, Blocks.SMOKER, Blocks.STONECUTTER});
    }

    private void addColored(TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            Identifier key = Identifier.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey<Block> tag = ForgeBlockTagsProvider.getForgeTag(prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + String.valueOf(key));
            }
            this.tag(tag).add((Object)block);
        }
    }

    private static void addColoredTags(Consumer<TagKey<Block>> consumer, TagKey<Block> group) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            TagKey<Block> tag = ForgeBlockTagsProvider.getForgeTag(prefix + color.getName());
            consumer.accept(tag);
        }
    }

    private static TagKey<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    private static TagKey<Block> forgeTagKey(String path) {
        return BlockTags.create((Identifier)Identifier.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Block Tags";
    }
}

