/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.renderable;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.renderable.IRenderable;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class BakedModelRenderable
implements IRenderable<Context> {
    private final BlockStateModel model;

    public static BakedModelRenderable of(BlockState state) {
        return BakedModelRenderable.of(Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state));
    }

    public static BakedModelRenderable of(BlockStateModel model) {
        return new BakedModelRenderable(model);
    }

    private BakedModelRenderable(BlockStateModel model) {
        this.model = model;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick, Context context) {
        VertexConsumer buffer = bufferSource.getBuffer(textureRenderTypeLookup.get(TextureAtlas.LOCATION_BLOCKS));
        Vector4f tint = context.tint();
        RandomSource randomSource = context.randomSource();
        randomSource.setSeed(context.seed());
        ArrayList parts = new ArrayList();
        this.model.collectParts(randomSource, parts, context.data(), null);
        for (BlockModelPart part : parts) {
            for (Direction direction : Direction.valuesView()) {
                for (BakedQuad quad : part.getQuads(direction)) {
                    buffer.putBulkData(poseStack.last(), quad, tint.x(), tint.y(), tint.z(), tint.w(), lightmap, overlay);
                }
            }
        }
    }

    @Override
    public IRenderable<Unit> withContext(ModelData modelData) {
        return this.withContext(new Context(modelData));
    }

    public IRenderable<ModelData> withModelDataContext() {
        return (poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, partialTick, context) -> this.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, partialTick, new Context((ModelData)context));
    }

    public record Context(@Nullable BlockState state, Direction[] faces, RandomSource randomSource, long seed, ModelData data, Vector4f tint) {
        private static final Direction[] ALL_FACES_AND_NULL = Arrays.copyOf(Direction.values(), Direction.values().length + 1);
        private static final Vector4f WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);

        public Context(ModelData data) {
            this(null, ALL_FACES_AND_NULL, RandomSource.create(), 42L, data, WHITE);
        }
    }
}

