/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.textures.UnitTextureAtlasSprite;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BakedQuadBuilder
implements VertexConsumer {
    private static final int MAX_VERTICES = 4;
    private final Consumer<BakedQuad> quadConsumer;
    int vertexIndex = -1;
    private Vector3f[] positions;
    private long[] uvs;
    private int tintIndex;
    private Direction direction = Direction.DOWN;
    private TextureAtlasSprite sprite = UnitTextureAtlasSprite.INSTANCE;
    private boolean shade;
    private boolean hasAmbientOcclusion;
    private int lightEmission;

    public BakedQuadBuilder(Consumer<BakedQuad> quadConsumer) {
        this.quadConsumer = quadConsumer;
        this.setup();
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        if (this.vertexIndex++ == 4) {
            this.build();
        }
        Vector3f pos = this.positions[this.vertexIndex];
        pos.x = x;
        pos.y = y;
        pos.z = z;
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        this.uvs[this.vertexIndex] = UVPair.pack((float)u, (float)v);
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        return this;
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        return this;
    }

    public VertexConsumer setColor(int packed) {
        return this;
    }

    public VertexConsumer setLineWidth(float packed) {
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        return this;
    }

    private void setup() {
        this.positions = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
        this.uvs = new long[4];
        this.vertexIndex = 0;
    }

    public BakedQuad build() {
        BakedQuad quad = new BakedQuad((Vector3fc)this.positions[0], (Vector3fc)this.positions[1], (Vector3fc)this.positions[2], (Vector3fc)this.positions[3], this.uvs[0], this.uvs[1], this.uvs[2], this.uvs[3], this.tintIndex, this.direction, this.sprite, this.shade, this.lightEmission, this.hasAmbientOcclusion);
        this.setup();
        this.quadConsumer.accept(quad);
        return quad;
    }

    public void setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public void setHasAmbientOcclusion(boolean hasAmbientOcclusion) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
    }

    public void setLightEmission(int value) {
        this.lightEmission = value;
    }

    public static class Single
    extends BakedQuadBuilder {
        private final BakedQuad[] output;

        public Single() {
            this(new BakedQuad[1]);
        }

        private Single(BakedQuad[] output) {
            super(q -> {
                output[0] = q;
            });
            this.output = output;
        }

        public BakedQuad getQuad() {
            BakedQuad quad = (BakedQuad)Preconditions.checkNotNull((Object)this.output[0], (Object)("No quad has been emitted. Vertices in buffer: " + this.vertexIndex));
            this.output[0] = null;
            return quad;
        }
    }
}

