/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.function.BiPredicate;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.Nullable;

public class StandaloneGeometryBakingContext
implements IGeometryBakingContext {
    public static final Identifier LOCATION = Identifier.fromNamespaceAndPath((String)"forge", (String)"standalone");
    public static final StandaloneGeometryBakingContext INSTANCE = StandaloneGeometryBakingContext.builder().build();
    private final boolean isGui3d;
    private final boolean useBlockLight;
    private final boolean useAmbientOcclusion;
    private final ItemTransforms transforms;
    private final Transformation rootTransform;
    @Nullable
    private final Identifier renderTypeHint;
    @Nullable
    private final Identifier renderTypeFastHint;
    private final BiPredicate<String, Boolean> visibilityTest;

    private StandaloneGeometryBakingContext(boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, ItemTransforms transforms, Transformation rootTransform, @Nullable Identifier renderTypeHint, BiPredicate<String, Boolean> visibilityTest) {
        this(isGui3d, useBlockLight, useAmbientOcclusion, transforms, rootTransform, renderTypeHint, null, visibilityTest);
    }

    private StandaloneGeometryBakingContext(boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, ItemTransforms transforms, Transformation rootTransform, @Nullable Identifier renderTypeHint, @Nullable Identifier renderTypeFastHint, BiPredicate<String, Boolean> visibilityTest) {
        this.isGui3d = isGui3d;
        this.useBlockLight = useBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.transforms = transforms;
        this.rootTransform = rootTransform;
        this.renderTypeHint = renderTypeHint;
        this.renderTypeFastHint = renderTypeFastHint;
        this.visibilityTest = visibilityTest;
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.useBlockLight;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @Override
    public Transformation getRootTransform() {
        return this.rootTransform;
    }

    @Override
    @Nullable
    public Identifier getRenderTypeHint() {
        return this.renderTypeHint;
    }

    @Override
    @Nullable
    public Identifier getRenderTypeFastHint() {
        return this.renderTypeFastHint;
    }

    @Override
    public boolean isComponentVisible(String component, boolean fallback) {
        return this.visibilityTest.test(component, fallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IGeometryBakingContext parent) {
        return new Builder(parent);
    }

    public static final class Builder {
        private boolean isGui3d = true;
        private boolean useBlockLight = true;
        private boolean useAmbientOcclusion = true;
        private ItemTransforms transforms = ItemTransforms.NO_TRANSFORMS;
        private Transformation rootTransform = Transformation.identity();
        @Nullable
        private Identifier renderTypeHint;
        @Nullable
        private Identifier renderTypeFastHint;
        private BiPredicate<String, Boolean> visibilityTest = (c, def) -> def;

        private Builder() {
        }

        private Builder(IGeometryBakingContext parent) {
            this.isGui3d = parent.isGui3d();
            this.useBlockLight = parent.useBlockLight();
            this.useAmbientOcclusion = parent.useAmbientOcclusion();
            this.transforms = parent.getTransforms();
            this.rootTransform = parent.getRootTransform();
            this.renderTypeHint = parent.getRenderTypeHint();
            this.renderTypeFastHint = parent.getRenderTypeFastHint();
            this.visibilityTest = parent::isComponentVisible;
        }

        public Builder withGui3d(boolean isGui3d) {
            this.isGui3d = isGui3d;
            return this;
        }

        public Builder withUseBlockLight(boolean useBlockLight) {
            this.useBlockLight = useBlockLight;
            return this;
        }

        public Builder withUseAmbientOcclusion(boolean useAmbientOcclusion) {
            this.useAmbientOcclusion = useAmbientOcclusion;
            return this;
        }

        public Builder withTransforms(ItemTransforms transforms) {
            this.transforms = transforms;
            return this;
        }

        public Builder withRootTransform(Transformation rootTransform) {
            this.rootTransform = rootTransform;
            return this;
        }

        public Builder withRenderTypeHint(Identifier renderTypeHint) {
            this.renderTypeHint = renderTypeHint;
            return this;
        }

        public Builder withRenderTypeHint(Identifier renderTypeHint, Identifier renderTypeFastHint) {
            this.renderTypeHint = renderTypeHint;
            this.renderTypeFastHint = renderTypeFastHint;
            return this;
        }

        public Builder withVisibleComponents(Object2BooleanMap<String> parts) {
            this.visibilityTest = (arg_0, arg_1) -> parts.getOrDefault(arg_0, arg_1);
            return this;
        }

        public StandaloneGeometryBakingContext build() {
            return new StandaloneGeometryBakingContext(this.isGui3d, this.useBlockLight, this.useAmbientOcclusion, this.transforms, this.rootTransform, this.renderTypeHint, this.renderTypeFastHint, this.visibilityTest);
        }
    }
}

