/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.mojang.math.Transformation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.model.ForgeBlockModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelContext(ResolvedModel self, ResolvedModel parent, @Nullable ForgeBlockModelData data, boolean gui3d) implements IGeometryBakingContext
{
    public ModelContext(ResolvedModel self) {
        this(self, self.parent(), ModelContext.makeData(self, self.parent()), true);
    }

    private static ForgeBlockModelData makeData(ResolvedModel self, ResolvedModel parent) {
        ForgeBlockModelData forgeBlockModelData;
        UnbakedModel unbakedModel = self.wrapped();
        if (unbakedModel instanceof BlockModel) {
            BlockModel block = (BlockModel)unbakedModel;
            forgeBlockModelData = block.forgeData();
        } else {
            forgeBlockModelData = null;
        }
        ForgeBlockModelData data = forgeBlockModelData;
        for (ResolvedModel p = parent; !(p == null || data != null && data.full()); p = (ModelDiscovery.ModelWrapper)p.parent()) {
            UnbakedModel unbakedModel2 = p.wrapped();
            if (!(unbakedModel2 instanceof BlockModel)) continue;
            BlockModel block = (BlockModel)unbakedModel2;
            data = data == null ? block.forgeData() : data.merge(block.forgeData());
        }
        return data;
    }

    @Override
    public boolean isGui3d() {
        return this.gui3d;
    }

    public ModelContext withGui3d(boolean value) {
        return new ModelContext(this.self, this.parent, this.data, value);
    }

    @Override
    public boolean useBlockLight() {
        UnbakedModel.GuiLight value = this.self.wrapped().guiLight();
        return value != null && value.lightLikeBlock();
    }

    @Override
    public boolean useAmbientOcclusion() {
        return Boolean.TRUE.equals(this.self.wrapped().ambientOcclusion());
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.self.wrapped().transforms();
    }

    @Override
    public Transformation getRootTransform() {
        return this.data == null ? Transformation.identity() : this.data.transform().orElse(Transformation.identity());
    }

    @Override
    @Nullable
    public Identifier getRenderTypeHint() {
        return this.data == null ? null : (Identifier)this.data.renderType().orElse(null);
    }

    @Override
    public boolean isComponentVisible(String component, boolean fallback) {
        if (this.data == null || this.data.visibility().isEmpty()) {
            return fallback;
        }
        return this.data.visibility().get().getOrDefault(component, fallback);
    }
}

