/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.mojang.math.Transformation;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraftforge.client.model.IQuadTransformer;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public final class QuadTransformers {
    private static final IQuadTransformer EMPTY = quad -> quad;

    public static IQuadTransformer empty() {
        return EMPTY;
    }

    public static IQuadTransformer applying(Transformation transform) {
        if (transform.isIdentity()) {
            return QuadTransformers.empty();
        }
        return quad -> {
            Vector3fc[] positions = new Vector3fc[4];
            for (int i = 0; i < 4; ++i) {
                Vector4f pos = new Vector4f(quad.position(i), 1.0f);
                transform.transformPosition(pos);
                pos.div(pos.w);
                positions[i] = new Vector3f(pos.x(), pos.y(), pos.z());
            }
            return new BakedQuad(positions[0], positions[1], positions[2], positions[3], quad.packedUV0(), quad.packedUV1(), quad.packedUV2(), quad.packedUV3(), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission(), quad.ambientOcclusion());
        };
    }

    public static int toABGR(int argb) {
        return argb & 0xFF00FF00 | argb >> 16 & 0xFF | argb << 16 & 0xFF0000;
    }

    private QuadTransformers() {
    }
}

