/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector4f;
import org.jspecify.annotations.NullMarked;

public sealed interface ViewportEvent {
    public GameRenderer getRenderer();

    public Camera getCamera();

    public float getPartialTick();

    @NullMarked
    public static final class ComputeFov
    extends MutableEvent
    implements ViewportEvent {
        public static final EventBus<ComputeFov> BUS = EventBus.create(ComputeFov.class);
        private final GameRenderer renderer;
        private final Camera camera;
        private final float partialTicks;
        private final boolean usedConfiguredFov;
        private float fov;

        @ApiStatus.Internal
        public ComputeFov(GameRenderer renderer, Camera camera, float renderPartialTicks, float fov, boolean usedConfiguredFov) {
            this.renderer = renderer;
            this.camera = camera;
            this.partialTicks = renderPartialTicks;
            this.usedConfiguredFov = usedConfiguredFov;
            this.setFOV(fov);
        }

        @Override
        public GameRenderer getRenderer() {
            return this.renderer;
        }

        @Override
        public Camera getCamera() {
            return this.camera;
        }

        @Override
        public float getPartialTick() {
            return this.partialTicks;
        }

        public float getFOV() {
            return this.fov;
        }

        public void setFOV(float fov) {
            this.fov = fov;
        }

        public boolean usedConfiguredFov() {
            return this.usedConfiguredFov;
        }
    }

    @NullMarked
    public static final class ComputeCameraAngles
    extends MutableEvent
    implements ViewportEvent {
        public static final EventBus<ComputeCameraAngles> BUS = EventBus.create(ComputeCameraAngles.class);
        private final GameRenderer renderer;
        private final Camera camera;
        private final float partialTicks;
        private float yaw;
        private float pitch;
        private float roll;

        @ApiStatus.Internal
        public ComputeCameraAngles(GameRenderer renderer, Camera camera, float renderPartialTicks, float yaw, float pitch, float roll) {
            this.renderer = renderer;
            this.camera = camera;
            this.partialTicks = renderPartialTicks;
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        @Override
        public GameRenderer getRenderer() {
            return this.renderer;
        }

        @Override
        public Camera getCamera() {
            return this.camera;
        }

        @Override
        public float getPartialTick() {
            return this.partialTicks;
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }

    public static final class ComputeFogColor
    extends MutableEvent
    implements ViewportEvent {
        public static final EventBus<ComputeFogColor> BUS = EventBus.create(ComputeFogColor.class);
        private final GameRenderer renderer;
        private final Camera camera;
        private final float partialTicks;
        private float red;
        private float green;
        private float blue;

        @ApiStatus.Internal
        public ComputeFogColor(Camera camera, float partialTicks, float red, float green, float blue) {
            this.renderer = Minecraft.getInstance().gameRenderer;
            this.camera = camera;
            this.partialTicks = partialTicks;
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        @Override
        public GameRenderer getRenderer() {
            return this.renderer;
        }

        @Override
        public Camera getCamera() {
            return this.camera;
        }

        @Override
        public float getPartialTick() {
            return this.partialTicks;
        }

        public float getRed() {
            return this.red;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public float getGreen() {
            return this.green;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    public record RenderFog(GameRenderer getRenderer, Camera getCamera, float getPartialTick, FogType getType, FogData getData, Vector4f getColor) implements Cancellable,
    ViewportEvent,
    RecordEvent
    {
        public static final CancellableEventBus<RenderFog> BUS = CancellableEventBus.create(RenderFog.class);

        @ApiStatus.Internal
        public RenderFog(FogType type, Camera camera, float partialTicks, FogData data, Vector4f color) {
            this(Minecraft.getInstance().gameRenderer, camera, partialTicks, type, data, color);
        }

        public float getFarPlaneDistance() {
            return this.getData().renderDistanceEnd;
        }

        public float getNearPlaneDistance() {
            return this.getData().renderDistanceStart;
        }

        public void setFarPlaneDistance(float distance) {
            this.getData().renderDistanceEnd = distance;
        }

        public void setNearPlaneDistance(float distance) {
            this.getData().renderDistanceStart = distance;
        }

        public void scaleFarPlaneDistance(float factor) {
            this.getData().renderDistanceEnd *= factor;
        }

        public void scaleNearPlaneDistance(float factor) {
            this.getData().renderDistanceStart *= factor;
        }
    }
}

