/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.Collection;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public final class RenderTypeHelper {
    @NotNull
    public static RenderType getEntityRenderType(ChunkSectionLayer layer) {
        return layer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
    }

    @NotNull
    public static RenderType getMovingBlockRenderType(ChunkSectionLayer layer) {
        if (layer == null) {
            return RenderTypes.solidMovingBlock();
        }
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> RenderTypes.solidMovingBlock();
            case ChunkSectionLayer.CUTOUT -> RenderTypes.cutoutMovingBlock();
            case ChunkSectionLayer.TRANSLUCENT -> RenderTypes.translucentMovingBlock();
            case ChunkSectionLayer.TRIPWIRE -> RenderTypes.tripwireMovingBlock();
        };
    }

    @NotNull
    public static RenderType getFallbackItemRenderType(ItemStack stack, BlockStateModel model) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Collection renderTypes = model.getRenderTypes(blockItem.getBlock().defaultBlockState(), RandomSource.create((long)42L), ModelData.EMPTY);
            if (renderTypes.contains(ChunkSectionLayer.TRANSLUCENT)) {
                return RenderTypeHelper.getEntityRenderType(ChunkSectionLayer.TRANSLUCENT);
            }
            return Sheets.cutoutBlockSheet();
        }
        return Sheets.translucentItemSheet();
    }

    private RenderTypeHelper() {
    }
}

