/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import org.jetbrains.annotations.ApiStatus;

public enum ForgeRenderTypes {
    ITEM_LAYERED_SOLID(() -> ForgeRenderTypes.getItemLayeredSolid(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_CUTOUT(() -> ForgeRenderTypes.getItemLayeredCutout(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_CUTOUT_MIPPED(() -> ForgeRenderTypes.getItemLayeredCutoutMipped(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_TRANSLUCENT(() -> ForgeRenderTypes.getItemLayeredTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNSORTED_TRANSLUCENT(() -> ForgeRenderTypes.getUnsortedTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNSORTED_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(ForgeRenderTypes.blockAtlas(), false));

    public static boolean enableTextTextureLinearFiltering;
    private final NonNullSupplier<RenderType> renderTypeSupplier;

    private static Identifier blockAtlas() {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public static RenderType getItemLayeredSolid(Identifier textureLocation) {
        return Internal.LAYERED_ITEM_SOLID.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutout(Identifier textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutoutMipped(Identifier textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getItemLayeredTranslucent(Identifier textureLocation) {
        return Internal.LAYERED_ITEM_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnsortedTranslucent(Identifier textureLocation) {
        return Internal.UNSORTED_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(Identifier textureLocation) {
        return Internal.UNLIT_TRANSLUCENT_SORTED.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(Identifier textureLocation, boolean sortingEnabled) {
        return (sortingEnabled ? Internal.UNLIT_TRANSLUCENT_SORTED : Internal.UNLIT_TRANSLUCENT_UNSORTED).apply(textureLocation);
    }

    public static RenderType getEntityCutoutMipped(Identifier textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getText(Identifier locationIn) {
        return Internal.TEXT.apply(locationIn);
    }

    public static RenderType getTextIntensity(Identifier locationIn) {
        return Internal.TEXT_INTENSITY.apply(locationIn);
    }

    public static RenderType getTextPolygonOffset(Identifier locationIn) {
        return Internal.TEXT_POLYGON_OFFSET.apply(locationIn);
    }

    public static RenderType getTextIntensityPolygonOffset(Identifier locationIn) {
        return Internal.TEXT_INTENSITY_POLYGON_OFFSET.apply(locationIn);
    }

    public static RenderType getTextSeeThrough(Identifier locationIn) {
        return Internal.TEXT_SEE_THROUGH.apply(locationIn);
    }

    public static RenderType getTextIntensitySeeThrough(Identifier locationIn) {
        return Internal.TEXT_INTENSITY_SEE_THROUGH.apply(locationIn);
    }

    @ApiStatus.Internal
    public static RenderType getLoadingOverlay(DisplayWindow window) {
        return Internal.getLoadingOverlay(window);
    }

    private ForgeRenderTypes(NonNullSupplier<RenderType> renderTypeSupplier) {
        this.renderTypeSupplier = NonNullLazy.of(renderTypeSupplier);
    }

    public RenderType get() {
        return this.renderTypeSupplier.get();
    }

    static {
        enableTextTextureLinearFiltering = false;
    }

    private static abstract class Internal {
        public static Function<Identifier, RenderType> UNSORTED_TRANSLUCENT = Util.memoize(Internal::unsortedTranslucent);
        public static Function<Identifier, RenderType> UNLIT_TRANSLUCENT_SORTED = Util.memoize(Internal::unlitTranslucentSorted);
        public static Function<Identifier, RenderType> UNLIT_TRANSLUCENT_UNSORTED = Util.memoize(Internal::unlitTranslucentUnsorted);
        public static Function<Identifier, RenderType> LAYERED_ITEM_SOLID = Util.memoize(Internal::layeredItemSolid);
        public static Function<Identifier, RenderType> LAYERED_ITEM_CUTOUT = Util.memoize(Internal::layeredItemCutout);
        public static Function<Identifier, RenderType> LAYERED_ITEM_CUTOUT_MIPPED = Util.memoize(Internal::layeredItemCutoutMipped);
        public static Function<Identifier, RenderType> LAYERED_ITEM_TRANSLUCENT = Util.memoize(Internal::layeredItemTranslucent);
        public static Function<Identifier, RenderType> TEXT = Util.memoize(Internal::getText);
        public static Function<Identifier, RenderType> TEXT_INTENSITY = Util.memoize(Internal::getTextIntensity);
        public static Function<Identifier, RenderType> TEXT_POLYGON_OFFSET = Util.memoize(Internal::getTextPolygonOffset);
        public static Function<Identifier, RenderType> TEXT_INTENSITY_POLYGON_OFFSET = Util.memoize(Internal::getTextIntensityPolygonOffset);
        public static Function<Identifier, RenderType> TEXT_SEE_THROUGH = Util.memoize(Internal::getTextSeeThrough);
        public static Function<Identifier, RenderType> TEXT_INTENSITY_SEE_THROUGH = Util.memoize(Internal::getTextIntensitySeeThrough);
        private static final RenderPipeline LOADING_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_TEXTURED_SNIPPET}).withLocation("pipeline/forge/loading_overlay").withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE)).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();
        private static final GpuSampler LOADING_SAMPLER = RenderSystem.getSamplerCache().getSampler(AddressMode.REPEAT, AddressMode.REPEAT, FilterMode.NEAREST, FilterMode.NEAREST, false);
        private static final Identifier LOADING_TEXTURE = Identifier.fromNamespaceAndPath((String)"forge", (String)"loading_overlay");

        private Internal() {
        }

        private static RenderType unsortedTranslucent(Identifier texture) {
            return RenderType.create((String)"forge_unsorted_translucent", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT).bufferSize(1536).withTexture("Sampler0", texture).bufferSize(1536).affectsCrumbling().useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType unlitTranslucentSorted(Identifier texture) {
            return RenderType.create((String)"forge_unlit_translucent_sorted", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT).bufferSize(1536).affectsCrumbling().sortOnUpload().withTexture("Sampler0", texture).useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType unlitTranslucentUnsorted(Identifier texture) {
            return RenderType.create((String)"forge_unlit_translucent_sorted", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT).bufferSize(1536).affectsCrumbling().withTexture("Sampler0", texture).useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType layeredItemSolid(Identifier texture) {
            return RenderType.create((String)"forge_layered_item_soild", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_SOLID).bufferSize(1536).affectsCrumbling().withTexture("Sampler0", texture).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType layeredItemCutout(Identifier texture) {
            return RenderType.create((String)"forge_layered_item_cutout", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_CUTOUT).bufferSize(1536).affectsCrumbling().withTexture("Sampler0", texture).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType layeredItemCutoutMipped(Identifier texture) {
            return RenderType.create((String)"forge_layered_item_cutout_mipped", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ENTITY_SMOOTH_CUTOUT).bufferSize(1536).affectsCrumbling().withTexture("Sampler0", texture).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType layeredItemTranslucent(Identifier texture) {
            return RenderType.create((String)"forge_layered_item_translucent", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL).bufferSize(1536).affectsCrumbling().sortOnUpload().withTexture("Sampler0", texture).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
        }

        private static RenderType getText(Identifier texture) {
            return RenderType.create((String)"forge_text", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT).withTexture("Sampler0", texture).useLightmap().bufferSize(786432).sortOnUpload().createRenderSetup());
        }

        private static RenderType getTextIntensity(Identifier texture) {
            return RenderType.create((String)"forge_text_intensity", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT_INTENSITY).bufferSize(786432).withTexture("Sampler0", texture).useLightmap().useOverlay().createRenderSetup());
        }

        private static RenderType getTextPolygonOffset(Identifier texture) {
            return RenderType.create((String)"forge_text_polygon_offset", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT_POLYGON_OFFSET).bufferSize(1536).sortOnUpload().withTexture("Sampler0", texture).useLightmap().createRenderSetup());
        }

        private static RenderType getTextIntensityPolygonOffset(Identifier texture) {
            return RenderType.create((String)"forge_text_intensity_polygon_offset", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT_INTENSITY).bufferSize(1536).sortOnUpload().withTexture("Sampler0", texture).useLightmap().createRenderSetup());
        }

        private static RenderType getTextSeeThrough(Identifier texture) {
            return RenderType.create((String)"forge_text_see_through", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT_SEE_THROUGH).bufferSize(1536).withTexture("Sampler0", texture).useLightmap().createRenderSetup());
        }

        private static RenderType getTextIntensitySeeThrough(Identifier texture) {
            return RenderType.create((String)"forge_text_intensity_see_through", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT_INTENSITY_SEE_THROUGH).bufferSize(1536).sortOnUpload().withTexture("Sampler0", texture).useLightmap().createRenderSetup());
        }

        public static RenderType getLoadingOverlay(DisplayWindow window) {
            GpuDevice gpu = RenderSystem.getDevice();
            GpuTexture texture = gpu.createTexture(LOADING_TEXTURE.toString(), 5, TextureFormat.RGBA8, window.context().width(), window.context().height(), 1, window.getFramebufferTextureId());
            GpuTextureView textureView = gpu.createTextureView(texture);
            return RenderType.create((String)"forge_loading_overlay", (RenderSetup)RenderSetup.builder((RenderPipeline)LOADING_PIPELINE).bufferSize(1536).withTexture("Sampler0", textureView, LOADING_SAMPLER).createRenderSetup());
        }
    }
}

