/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.particle.ParticleResources;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.data.AtlasIds;
import net.minecraft.locale.Language;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FileUtil;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.ColorResolverManager;
import net.minecraftforge.client.EntitySpectatorShaderManager;
import net.minecraftforge.client.ExtendedServerListData;
import net.minecraftforge.client.FramePassManager;
import net.minecraftforge.client.ItemDecoratorHandler;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.PresetEditorManager;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPauseChangeEvent;
import net.minecraftforge.client.event.ClientPlayerChangeGameTypeEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.event.GatherAtlasMetadataSectionsEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterPictureInPictureRendererEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.SystemMessageReceivedEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.client.gui.ClientTooltipComponentManager;
import net.minecraftforge.client.gui.ModMismatchDisconnectedScreen;
import net.minecraftforge.client.model.ForgeBlockModelData;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.GeometryLoaderManager;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import net.minecraftforge.client.textures.TextureAtlasSpriteLoaderManager;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.ServerStatusPing;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4f;

@ApiStatus.Internal
public class ForgeHooksClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final Stack<Screen> guiLayers = new Stack();
    private static final RenderHighlightEvent.Callback NOOP_HIGHLIGHTER = (source, stack, translucent, state) -> {};
    public static String forgeStatusLine;
    private static int slotMainHand;
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions;
    private static final Identifier ICON_SHEET;
    private static boolean initializedClientHooks;

    public static void resizeGuiLayers(Minecraft minecraft, int width, int height) {
        guiLayers.forEach(screen -> screen.resize(width, height));
    }

    public static void clearGuiLayers(Minecraft minecraft) {
        while (!guiLayers.isEmpty()) {
            ForgeHooksClient.popGuiLayerInternal(minecraft);
        }
    }

    private static void popGuiLayerInternal(Minecraft minecraft) {
        if (minecraft.screen != null) {
            minecraft.screen.removed();
        }
        minecraft.screen = guiLayers.pop();
    }

    public static void pushGuiLayer(Minecraft minecraft, Screen screen) {
        if (minecraft.screen != null) {
            guiLayers.push(minecraft.screen);
        }
        minecraft.screen = Objects.requireNonNull(screen);
        screen.init(minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
        minecraft.getNarrator().saySystemNow(screen.getNarrationMessage());
    }

    public static void popGuiLayer(Minecraft minecraft) {
        if (guiLayers.isEmpty()) {
            minecraft.setScreen(null);
            return;
        }
        ForgeHooksClient.popGuiLayerInternal(minecraft);
        if (minecraft.screen != null) {
            minecraft.getNarrator().saySystemNow(minecraft.screen.getNarrationMessage());
        }
    }

    public static float getGuiFarPlane() {
        return 11000.0f + 10000.0f * (float)(1 + guiLayers.size());
    }

    public static boolean onClientPauseChangePre(boolean pause) {
        return ClientPauseChangeEvent.Pre.BUS.post((Event)new ClientPauseChangeEvent.Pre(pause));
    }

    public static void onClientPauseChangePost(boolean pause) {
        ClientPauseChangeEvent.Post.BUS.post((Event)new ClientPauseChangeEvent.Post(pause));
    }

    public static RenderHighlightEvent.Callback onExtractBlockOutline(LevelRenderer context, Camera camera, LevelRenderState state, HitResult target) {
        if (target instanceof BlockHitResult) {
            BlockHitResult blockTarget = (BlockHitResult)target;
            RenderHighlightEvent.Block event = new RenderHighlightEvent.Block(context, camera, state, blockTarget);
            if (RenderHighlightEvent.Block.BUS.post((Event)event)) {
                return NOOP_HIGHLIGHTER;
            }
            return event.getCustomRenderer();
        }
        if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            RenderHighlightEvent.Entity event = new RenderHighlightEvent.Entity(context, camera, state, entityTarget);
            if (RenderHighlightEvent.Entity.BUS.post((Event)event)) {
                return NOOP_HIGHLIGHTER;
            }
            return event.getCustomRenderer();
        }
        return null;
    }

    public static boolean renderSpecificFirstPersonHand(InteractionHand hand, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, float partialTick, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return RenderHandEvent.BUS.post((Event)new RenderHandEvent(hand, poseStack, nodeCollector, packedLight, partialTick, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPost(TextureAtlas map) {
        TextureStitchEvent.Post.BUS.post((Event)new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        RegisterColorHandlersEvent.Block.BUS.post((Event)new RegisterColorHandlersEvent.Block(blockColors));
    }

    public static Model getArmorModel(HumanoidRenderState state, ItemStack itemStack, EquipmentSlot slot, HumanoidModel<?> _default) {
        return IClientItemExtensions.of(itemStack).getGenericArmorModel(state, itemStack, slot, _default);
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1);
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    @Nullable
    public static SoundInstance playSound(SoundEngine manager, SoundInstance sound) {
        return ((PlaySoundEvent)PlaySoundEvent.BUS.fire((Event)new PlaySoundEvent(manager, sound))).getSound();
    }

    public static void drawScreen(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushMatrix();
        for (Screen layer : guiLayers) {
            ForgeHooksClient.drawScreenInternal(layer, guiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
        }
        ForgeHooksClient.drawScreenInternal(screen, guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().popMatrix();
    }

    private static void drawScreenInternal(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!ScreenEvent.Render.Pre.BUS.post((Event)new ScreenEvent.Render.Pre(screen, guiGraphics, mouseX, mouseY, partialTick))) {
            screen.renderWithTooltipAndSubtitles(guiGraphics, mouseX, mouseY, partialTick);
        }
        ScreenEvent.Render.Post.BUS.post((Event)new ScreenEvent.Render.Post(screen, guiGraphics, mouseX, mouseY, partialTick));
    }

    public static Vector3f getFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, float fogRed, float fogGreen, float fogBlue) {
        FluidState state = level.getFluidState(camera.blockPosition());
        Vector3f fluidFogColor = new Vector3f(fogRed, fogGreen, fogBlue);
        if (camera.position().y < (double)((float)camera.blockPosition().getY() + state.getHeight((BlockGetter)level, camera.blockPosition()))) {
            fluidFogColor = IClientFluidTypeExtensions.of(state).modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        }
        ViewportEvent.ComputeFogColor event = (ViewportEvent.ComputeFogColor)ViewportEvent.ComputeFogColor.BUS.fire((Event)new ViewportEvent.ComputeFogColor(camera, partialTick, fluidFogColor.x(), fluidFogColor.y(), fluidFogColor.z()));
        fluidFogColor.set(event.getRed(), event.getGreen(), event.getBlue());
        return fluidFogColor;
    }

    public static Vector4f setupFog(FogType type, Camera camera, DeltaTracker delta, FogData data, Vector4f color) {
        FluidState state = camera.entity().level().getFluidState(camera.blockPosition());
        if (camera.position().y < (double)((float)camera.blockPosition().getY() + state.getHeight((BlockGetter)camera.entity().level(), camera.blockPosition()))) {
            IClientFluidTypeExtensions.of(state).modifyFogRender(camera, type, delta.getRealtimeDeltaTicks(), data, color);
        }
        ViewportEvent.RenderFog.BUS.post((Event)new ViewportEvent.RenderFog(type, camera, delta.getRealtimeDeltaTicks(), data, color));
        return color;
    }

    public static void onModifyBakingResult(ModelBakery modelBakery, ModelBakery.BakingResult results) {
        ModelEvent.ModifyBakingResult.BUS.post((Event)new ModelEvent.ModifyBakingResult(modelBakery, results));
    }

    public static void onModelBake(ModelManager modelManager, ModelBakery modelBakery) {
        ModelEvent.BakingCompleted.BUS.post((Event)new ModelEvent.BakingCompleted(modelManager, modelBakery));
    }

    public static TextureAtlasSprite[] getFluidSprites(BlockAndTintGetter level, BlockPos pos, FluidState fluidStateIn) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of(fluidStateIn);
        Identifier overlayTexture = props.getOverlayTexture(fluidStateIn, level, pos);
        TextureAtlas atlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        return new TextureAtlasSprite[]{atlas.getSprite(props.getStillTexture(fluidStateIn, level, pos)), atlas.getSprite(props.getFlowingTexture(fluidStateIn, level, pos)), overlayTexture == null ? null : atlas.getSprite(overlayTexture)};
    }

    public static boolean shouldCauseReequipAnimation(@NotNull ItemStack from, @NotNull ItemStack to, int slot) {
        boolean fromInvalid = from.isEmpty();
        boolean toInvalid = to.isEmpty();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.getItem().shouldCauseReequipAnimation(from, to, changed);
    }

    @Nullable
    public static CustomizeGuiOverlayEvent.BossEventProgress onCustomizeBossEventProgress(GuiGraphics guiGraphics, Window window, LerpingBossEvent bossInfo, int x, int y, int increment) {
        CustomizeGuiOverlayEvent.BossEventProgress evt = new CustomizeGuiOverlayEvent.BossEventProgress(window, guiGraphics, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false), bossInfo, x, y, increment);
        return CustomizeGuiOverlayEvent.BossEventProgress.BUS.post((Event)evt) ? null : evt;
    }

    public static void onCustomizeChatEvent(GuiGraphics guiGraphics, ChatComponent chat, Window window, int mouseX, int mouseY, int tickCount, Font font) {
        Minecraft minecraft = Minecraft.getInstance();
        CustomizeGuiOverlayEvent.Chat evt = new CustomizeGuiOverlayEvent.Chat(window, guiGraphics, minecraft.getDeltaTracker().getRealtimeDeltaTicks(), 0, chat.getHeight() - 40);
        CustomizeGuiOverlayEvent.Chat.BUS.post((Event)evt);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)evt.getPosX(), (float)((double)(evt.getPosY() - chat.getHeight() + 40) / chat.getScale()));
        chat.render(guiGraphics, font, tickCount, mouseX, mouseY, false, false);
        guiGraphics.pose().popMatrix();
    }

    public static void onCustomizeDebugEvent(GuiGraphics guiGraphics, Window window, float partialTick, List<String> text, boolean isLeft) {
        CustomizeGuiOverlayEvent.DebugText evt = new CustomizeGuiOverlayEvent.DebugText(window, guiGraphics, partialTick, text, isLeft ? CustomizeGuiOverlayEvent.DebugText.Side.Left : CustomizeGuiOverlayEvent.DebugText.Side.Right);
        CustomizeGuiOverlayEvent.DebugText.BUS.post((Event)evt);
    }

    public static void onClientChangeGameType(PlayerInfo info, GameType currentGameMode, GameType newGameMode) {
        if (currentGameMode != newGameMode) {
            ClientPlayerChangeGameTypeEvent.BUS.post((Event)new ClientPlayerChangeGameTypeEvent(info, currentGameMode, newGameMode));
        }
    }

    public static void onMovementInputUpdate(Player player, ClientInput movementInput) {
        MovementInputUpdateEvent.BUS.post((Event)new MovementInputUpdateEvent(player, movementInput));
    }

    public static boolean onScreenKeyPressed(Screen screen, KeyEvent info) {
        return ForgeEventFactoryClient.onScreenKeyPressedPre(screen, info) || screen.keyPressed(info) || ForgeEventFactoryClient.onScreenKeyPressedPost(screen, info);
    }

    public static boolean onScreenKeyReleased(Screen screen, KeyEvent info) {
        return ForgeEventFactoryClient.onScreenKeyReleasedPre(screen, info) || screen.keyReleased(info) || ForgeEventFactoryClient.onScreenKeyReleasedPost(screen, info);
    }

    public static boolean onScreenCharTyped(Screen screen, CharacterEvent info) {
        return ForgeEventFactoryClient.onScreenCharTypedPre(screen, info) || screen.charTyped(info) || ForgeEventFactoryClient.onScreenCharTypedPost(screen, info);
    }

    public static void onKeyInput(KeyEvent info, int action) {
        InputEvent.Key.BUS.post((Event)new InputEvent.Key(info, action));
    }

    public static boolean isNameplateInRenderDistance(Entity entity, double squareDistance) {
        LivingEntity living;
        AttributeInstance attribute;
        if (entity instanceof LivingEntity && (attribute = (living = (LivingEntity)entity).getAttribute(ForgeMod.NAMETAG_DISTANCE.getHolder().get())) != null) {
            return !(squareDistance > attribute.getValue() * attribute.getValue());
        }
        return !(squareDistance > 4096.0);
    }

    public static boolean shouldRenderEffect(MobEffectInstance effectInstance) {
        return IClientMobEffectExtensions.of(effectInstance).isVisibleInInventory(effectInstance);
    }

    public static Set<MetadataSectionType<?>> getAtlastMetadataSections(Identifier atlasId, Set<MetadataSectionType<?>> vanilla) {
        HashSet ret = new HashSet(vanilla);
        ret.add(ForgeTextureMetadata.TYPE);
        GatherAtlasMetadataSectionsEvent event = new GatherAtlasMetadataSectionsEvent(ret);
        GatherAtlasMetadataSectionsEvent.BUS.post((Event)event);
        return Set.of(ret.toArray(new MetadataSectionType[0]));
    }

    @Nullable
    public static SpriteContents loadSpriteContents(Identifier name, Resource resource, FrameSize frameSize, NativeImage image, List<MetadataSectionType.WithValue<?>> metadata) {
        for (MetadataSectionType.WithValue<?> meta : metadata) {
            ForgeTextureMetadata forgeMeta = meta.unwrapToType(ForgeTextureMetadata.TYPE).orElse(null);
            if (forgeMeta == null || forgeMeta.loader() == null) continue;
            return forgeMeta.loader().loadContents(name, resource, frameSize, image, metadata);
        }
        return null;
    }

    @Nullable
    public static TextureAtlasSprite loadTextureAtlasSprite(Identifier atlasName, SpriteContents contents, int atlasWidth, int atlasHeight, int spriteX, int spriteY, int padding, int mipmapLevel) {
        ForgeTextureMetadata forgeMeta = contents.getAdditionalMetadata(ForgeTextureMetadata.TYPE).orElse(null);
        if (forgeMeta == null || forgeMeta.loader() == null) {
            return null;
        }
        return forgeMeta.loader().makeSprite(atlasName, contents, atlasWidth, atlasHeight, spriteX, spriteY, padding, mipmapLevel);
    }

    public static void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
        layerDefinitions.put(layerLocation, supplier);
    }

    public static void loadLayerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> builder) {
        for (Map.Entry<ModelLayerLocation, Supplier<LayerDefinition>> entry : layerDefinitions.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
    }

    public static void processForgeListPingData(ServerStatus packet, ServerData target) {
        packet.forgeData().ifPresentOrElse(forgeData -> {
            int wantedVer;
            Map<String, String> mods = forgeData.getRemoteModData();
            Map<Identifier, ServerStatusPing.ChannelData> remoteChannels = forgeData.getRemoteChannels();
            int fmlver = forgeData.getFMLNetworkVersion();
            boolean fmlNetMatches = fmlver == (wantedVer = NetworkInitialization.getVersion());
            boolean channelsMatch = NetworkRegistry.checkListPingCompatibilityForClient(remoteChannels);
            AtomicBoolean result = new AtomicBoolean(true);
            ArrayList extraClientMods = new ArrayList();
            ModList.get().forEachModContainer((modid, mc) -> mc.getCustomExtension(IExtensionPoint.DisplayTest.class).ifPresent(ext -> {
                boolean foundModOnServer = ext.remoteVersionTest().test((String)mods.get(modid), true);
                result.compareAndSet(true, foundModOnServer);
                if (!foundModOnServer) {
                    extraClientMods.add(modid);
                }
            }));
            boolean modsMatch = result.get();
            Map<String, String> extraServerMods = mods.entrySet().stream().filter(e -> !Objects.equals("SERVER_ONLY", e.getValue())).filter(e -> !ModList.get().isLoaded((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LOGGER.debug(CLIENTHOOKS, "Received FML ping data from server at {}: FMLNETVER={}, mod list is compatible : {}, channel list is compatible: {}, extra server mods: {}", (Object)target.ip, (Object)fmlver, (Object)modsMatch, (Object)channelsMatch, extraServerMods);
            String extraReason = null;
            if (!extraServerMods.isEmpty()) {
                extraReason = "fml.menu.multiplayer.extraservermods";
                LOGGER.info(CLIENTHOOKS, ForgeI18n.parseMessage(extraReason, new Object[0]) + ": {}", (Object)extraServerMods.entrySet().stream().map(e -> (String)e.getKey() + "@" + (String)e.getValue()).collect(Collectors.joining(", ")));
            }
            if (!modsMatch) {
                extraReason = "fml.menu.multiplayer.modsincompatible";
                LOGGER.info(CLIENTHOOKS, "Client has mods that are missing on server: {}", extraClientMods);
            }
            if (!channelsMatch) {
                extraReason = "fml.menu.multiplayer.networkincompatible";
            }
            if (fmlver < wantedVer) {
                extraReason = "fml.menu.multiplayer.serveroutdated";
            }
            if (fmlver > wantedVer) {
                extraReason = "fml.menu.multiplayer.clientoutdated";
            }
            target.forgeData = new ExtendedServerListData("FML", extraServerMods.isEmpty() && fmlNetMatches && channelsMatch && modsMatch, mods.size(), extraReason, forgeData.isTruncated());
        }, () -> {
            target.forgeData = new ExtendedServerListData("VANILLA", NetworkRegistry.canConnectToVanillaServer(), 0, null);
        });
    }

    public static void drawForgePingInfo(JoinMultiplayerScreen gui, ServerData target, GuiGraphics guiGraphics, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Object tooltip;
        int idx;
        if (target.forgeData == null) {
            return;
        }
        switch (target.forgeData.type()) {
            case "FML": {
                if (target.forgeData.isCompatible()) {
                    idx = 0;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.compatible", target.forgeData.numberOfMods());
                } else {
                    idx = 16;
                    if (target.forgeData.extraReason() != null) {
                        String extraReason = ForgeI18n.parseMessage(target.forgeData.extraReason(), new Object[0]);
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible.extra", extraReason);
                    } else {
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible", new Object[0]);
                    }
                }
                if (!target.forgeData.truncated()) break;
                tooltip = (String)tooltip + "\n" + ForgeI18n.parseMessage("fml.menu.multiplayer.truncated", new Object[0]);
                break;
            }
            case "VANILLA": {
                if (target.forgeData.isCompatible()) {
                    idx = 48;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla", new Object[0]);
                    break;
                }
                idx = 80;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla.incompatible", new Object[0]);
                break;
            }
            default: {
                idx = 64;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.unknown", target.forgeData.type());
            }
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ICON_SHEET, x + width - 18, y + 10, 16.0f, 16.0f, 0, idx, 16, 16, 256, 256);
        if (relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26) {
            List<MutableComponent> lines = Arrays.stream(((String)tooltip).split("\n")).map(Component::literal).toList();
            guiGraphics.setTooltipForNextFrame(Lists.transform(lines, Component::getVisualOrderText), relativeMouseX + x, relativeMouseY + y);
        }
    }

    private static Connection getClientConnection() {
        return Minecraft.getInstance().getConnection() != null ? Minecraft.getInstance().getConnection().getConnection() : null;
    }

    public static void handleClientLevelClosing(ClientLevel level) {
        Connection client = ForgeHooksClient.getClientConnection();
        if (client != null && !client.isMemoryConnection()) {
            GameData.revertToFrozen();
        }
    }

    public static void onRegisterParticleProviders(ParticleResources particles) {
        RegisterParticleProvidersEvent.BUS.post((Event)new RegisterParticleProvidersEvent(particles));
    }

    public static void onRegisterKeyMappings(Options options) {
        RegisterKeyMappingsEvent.BUS.post((Event)new RegisterKeyMappingsEvent(options));
    }

    public static void onRegisterPictureInPictureRenderers(List<PictureInPictureRenderer<?>> renderers, MultiBufferSource.BufferSource bufferSource, ImmutableMap.Builder<Class<? extends PictureInPictureRenderState>, PictureInPictureRenderer<?>> builder) {
        RegisterPictureInPictureRendererEvent.BUS.post((Event)new RegisterPictureInPictureRendererEvent(renderers, bufferSource, builder));
    }

    @Nullable
    public static Component onClientChat(ChatType.Bound boundChatType, Component message, UUID sender) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(boundChatType, message, sender);
        return ClientChatReceivedEvent.BUS.post((Event)event) ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientPlayerChat(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage, UUID sender) {
        ClientChatReceivedEvent.Player event = new ClientChatReceivedEvent.Player(boundChatType, message, playerChatMessage, sender);
        return ClientChatReceivedEvent.Player.BUS.post((Event)event) ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientSystemMessage(Component message, boolean overlay) {
        SystemMessageReceivedEvent event = new SystemMessageReceivedEvent(message, overlay);
        return SystemMessageReceivedEvent.BUS.post((Event)event) ? null : event.getMessage();
    }

    @NotNull
    public static String onClientSendMessage(String message) {
        ClientChatEvent event = new ClientChatEvent(message);
        return ClientChatEvent.BUS.post((Event)event) ? "" : event.getMessage();
    }

    public static Font getTooltipFont(@NotNull ItemStack stack, Font fallbackFont) {
        Font stackFont = IClientItemExtensions.of(stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        return stackFont == null ? fallbackFont : stackFont;
    }

    @Nullable
    public static RenderTooltipEvent.Pre onRenderTooltipPre(@NotNull ItemStack stack, GuiGraphics graphics, int x, int y, int screenWidth, int screenHeight, @NotNull List<ClientTooltipComponent> components, @NotNull Font fallbackFont, @NotNull ClientTooltipPositioner positioner, @Nullable Identifier background) {
        RenderTooltipEvent.Pre preEvent = new RenderTooltipEvent.Pre(stack, graphics, x, y, screenWidth, screenHeight, ForgeHooksClient.getTooltipFont(stack, fallbackFont), components, positioner, background);
        return RenderTooltipEvent.Pre.BUS.post((Event)preEvent) ? null : preEvent;
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        return ForgeHooksClient.gatherTooltipComponents(stack, textElements, Optional.empty(), mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        return ForgeHooksClient.gatherTooltipComponentsFromElements(stack, elements, mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponentsFromElements(ItemStack stack, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ForgeHooksClient.getTooltipFont(stack, fallbackFont);
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(stack, screenWidth, screenHeight, elements, -1);
        if (RenderTooltipEvent.GatherComponents.BUS.post((Event)event)) {
            return List.of();
        }
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> ForgeHooksClient.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
        }
        return event.getTooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), ClientTooltipComponent::create)).toList();
    }

    private static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.getVisualOrderText()).map(ClientTooltipComponent::create);
        }
        return font.split(text, maxWidth).stream().map(ClientTooltipComponent::create);
    }

    public static boolean isBlockInSolidLayer(BlockState state) {
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        return model.getRenderTypes(state, RandomSource.create(), ModelData.EMPTY).contains(ChunkSectionLayer.SOLID);
    }

    public static void createWorldConfirmationScreen(Runnable doConfirmedWorldLoad) {
        MutableComponent title = Component.translatable((String)"selectWorld.backupQuestion.experimental");
        MutableComponent msg = Component.translatable((String)"selectWorld.backupWarning.experimental").append("\n\n").append((Component)Component.translatable((String)"forge.selectWorld.backupWarning.experimental.additional"));
        ConfirmScreen screen = new ConfirmScreen(confirmed -> {
            if (confirmed) {
                doConfirmedWorldLoad.run();
            } else {
                Minecraft.getInstance().setScreen(null);
            }
        }, (Component)title, (Component)msg, CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL);
        Minecraft.getInstance().setScreen((Screen)screen);
    }

    public static boolean renderFireOverlay(Player player, PoseStack mat) {
        return ForgeHooksClient.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.FIRE, Blocks.FIRE.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderWaterOverlay(Player player, PoseStack mat) {
        return ForgeHooksClient.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.WATER, Blocks.WATER.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderBlockOverlay(Player player, PoseStack mat, RenderBlockScreenEffectEvent.OverlayType type, BlockState block, BlockPos pos) {
        return RenderBlockScreenEffectEvent.BUS.post((Event)new RenderBlockScreenEffectEvent(player, mat, type, block, pos));
    }

    public static int getMaxMipmapLevel(int width, int height) {
        return Math.min(Mth.log2((int)Math.max(1, width)), Mth.log2((int)Math.max(1, height)));
    }

    public static Identifier getShaderImportLocation(String basePath, boolean isRelative, String importPath) {
        Identifier loc = Identifier.parse((String)importPath);
        String normalised = FileUtil.normalizeResourcePath((String)((isRelative ? basePath : "shaders/include/") + loc.getPath()));
        return loc.withPath(normalised);
    }

    @ApiStatus.Internal
    public static void initClientHooks(Minecraft mc, ReloadableResourceManager resourceManager) {
        if (initializedClientHooks) {
            throw new IllegalStateException("Client hooks initialized more than once");
        }
        initializedClientHooks = true;
        RegisterClientReloadListenersEvent.BUS.post((Event)new RegisterClientReloadListenersEvent(resourceManager));
        EntityRenderersEvent.RegisterLayerDefinitions.BUS.post((Event)new EntityRenderersEvent.RegisterLayerDefinitions());
        EntityRenderersEvent.RegisterRenderers.BUS.post((Event)new EntityRenderersEvent.RegisterRenderers());
        TextureAtlasSpriteLoaderManager.init();
        ClientTooltipComponentManager.init();
        EntitySpectatorShaderManager.init();
        ForgeHooksClient.onRegisterKeyMappings(mc.options);
        NamedRenderTypeManager.init();
        ColorResolverManager.init();
        ItemDecoratorHandler.init();
        PresetEditorManager.init();
    }

    public static boolean onClientDisconnect(Connection connection, Minecraft mc, Screen parent, Component message) {
        NetworkContext.NetworkMismatchData mismatch = NetworkContext.get(connection).getMismatchs();
        if (mismatch == null) {
            return false;
        }
        mc.setScreen((Screen)new ModMismatchDisconnectedScreen(parent, CommonComponents.CONNECT_FAILED, message, mismatch));
        return true;
    }

    public static boolean onScreenMouseDrag(Screen screen, MouseButtonEvent info, double dragX, double dragY) {
        return ForgeEventFactoryClient.onScreenMouseDragPre(screen, info.x(), info.y(), info.button(), dragX, dragY) || screen.mouseDragged(info, dragX, dragY) || ForgeEventFactoryClient.onScreenMouseDragPost(screen, info.x(), info.y(), info.button(), dragX, dragY);
    }

    @Nullable
    public static UnbakedGeometry deserializeBlockModelGeometry(JsonObject json, JsonDeserializationContext context) {
        String name = GsonHelper.getAsString((JsonObject)json, (String)"loader", null);
        if (name == null) {
            return null;
        }
        IGeometryLoader loader = GeometryLoaderManager.get(Identifier.parse((String)name));
        if (loader == null) {
            throw new JsonParseException(String.format(Locale.ENGLISH, "Model loader '%s' not found. Registered loaders: %s", name, GeometryLoaderManager.getLoaderList()));
        }
        return loader.read(json, context);
    }

    @Nullable
    public static ForgeBlockModelData deserializeBlockModel(JsonObject json, JsonDeserializationContext context) {
        JsonObject visibilityJson;
        String renderTypeFastName;
        Optional<Identifier> renderType = Optional.empty();
        Optional<Identifier> renderTypeFast = Optional.empty();
        Optional<Map<String, Boolean>> visibility = Optional.empty();
        Optional<Transformation> transform = Optional.ofNullable((Transformation)GsonHelper.getAsObject((JsonObject)json, (String)"transform", null, (JsonDeserializationContext)context, Transformation.class));
        String renderTypeName = GsonHelper.getAsString((JsonObject)json, (String)"render_type", null);
        if (renderTypeName != null) {
            renderType = Optional.of(Identifier.parse((String)renderTypeName));
        }
        if ((renderTypeFastName = GsonHelper.getAsString((JsonObject)json, (String)"render_type_fast", null)) != null) {
            renderTypeFast = Optional.of(Identifier.parse((String)renderTypeFastName));
        }
        if ((visibilityJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)"visibility", null)) != null) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (Map.Entry part : visibilityJson.entrySet()) {
                map.put((Object)((String)part.getKey()), (Object)((JsonElement)part.getValue()).getAsBoolean());
            }
            visibility = Optional.of(map.build());
        }
        return new ForgeBlockModelData(transform, renderType, renderTypeFast, visibility);
    }

    public static ModelBaker wrapRenderType(ModelBaker parent, RenderTypeGroup group) {
        if (group == null || group == RenderTypeGroup.EMPTY || parent.renderType() != null) {
            return parent;
        }
        return new WrapedModelBaker(parent, group);
    }

    public static ModelBaker wrapRenderType(ModelBaker parent, RenderTypeGroup group, RenderTypeGroup groupFast) {
        if (group == null || group == RenderTypeGroup.EMPTY || parent.renderType() != null) {
            return parent;
        }
        return new WrapedModelBaker(parent, group, groupFast);
    }

    public static void addFramePass(Identifier rl, FramePassManager.PassDefinition definition) {
        FramePassManager.addPass(rl, definition);
    }

    static {
        slotMainHand = 0;
        layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        ICON_SHEET = Identifier.fromNamespaceAndPath((String)"forge", (String)"textures/gui/icons.png");
        initializedClientHooks = false;
    }

    private record WrapedModelBaker(ModelBaker parent, RenderTypeGroup group, RenderTypeGroup renderTypeFast) implements ModelBaker
    {
        private WrapedModelBaker(ModelBaker parent, RenderTypeGroup group) {
            this(parent, group, RenderTypeGroup.EMPTY);
        }

        public RenderTypeGroup renderType() {
            return this.group;
        }

        public ResolvedModel getModel(Identifier p_397309_) {
            return this.parent.getModel(p_397309_);
        }

        public SpriteGetter sprites() {
            return this.parent.sprites();
        }

        public <T> T compute(ModelBaker.SharedOperationKey<T> p_395456_) {
            return (T)this.parent.compute(p_395456_);
        }

        public BlockModelPart missingBlockModelPart() {
            return this.parent.missingBlockModelPart();
        }

        public ModelBaker.PartCache parts() {
            return this.parent.parts();
        }
    }
}

