/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VolatileCallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.internal.AbstractEventBusImpl;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.eventbus.internal.EventListenerImpl;
import net.minecraftforge.eventbus.internal.InvokerFactory;
import org.jspecify.annotations.Nullable;

public record CancellableEventBusImpl<T extends Event & Cancellable>(String busGroupName, Class<T> eventType, CallSite invokerCallSite, ArrayList<EventListener> backingList, ArrayList<EventListener> monitorBackingList, List<AbstractEventBusImpl<?, ?>> children, AtomicBoolean alreadyInvalidated, AtomicBoolean shutdownFlag, int eventCharacteristics) implements CancellableEventBus<T>,
AbstractEventBusImpl<T, Predicate<T>>
{
    public CancellableEventBusImpl(String busGroupName, Class<T> eventType, ArrayList<EventListener> backingList, int eventCharacteristics) {
        this(busGroupName, eventType, new VolatileCallSite(backingList.isEmpty() ? Constants.MH_NO_OP_PREDICATE : Constants.MH_NULL_PREDICATE), backingList, new ArrayList<EventListener>(), AbstractEventBusImpl.makeEventChildrenList(eventType, eventCharacteristics), new AtomicBoolean(), new AtomicBoolean(), eventCharacteristics);
    }

    @Override
    public EventListener addListener(Consumer<T> listener) {
        return this.addListener(new EventListenerImpl.WrappedConsumerListener(this.eventType, 0, listener));
    }

    @Override
    public EventListener addListener(byte priority, Consumer<T> listener) {
        return this.addListener((EventListener)((Object)(priority == -128 ? new EventListenerImpl.MonitoringListener(this.eventType, listener) : new EventListenerImpl.WrappedConsumerListener(this.eventType, priority, listener))));
    }

    @Override
    public EventListener addListener(byte priority, boolean alwaysCancelling, Consumer<T> listener) {
        if (!alwaysCancelling) {
            throw new IllegalArgumentException("If you never cancel the event, call addListener(byte, Consumer<T>)instead to avoid the possibility of an unnecessary breaking change if the event is no longercancellable in the future");
        }
        if (priority == -128) {
            throw new IllegalArgumentException("Monitoring listeners cannot cancel events");
        }
        return this.addListener(new EventListenerImpl.WrappedConsumerListener(this.eventType, priority, true, listener));
    }

    @Override
    public EventListener addListener(Predicate<T> listener) {
        return this.addListener(new EventListenerImpl.PredicateListener(this.eventType, 0, listener));
    }

    @Override
    public EventListener addListener(byte priority, Predicate<T> listener) {
        if (priority == -128) {
            throw new IllegalArgumentException("Monitoring listeners cannot cancel events");
        }
        return this.addListener(new EventListenerImpl.PredicateListener(this.eventType, priority, listener));
    }

    @Override
    public EventListener addListener(ObjBooleanBiConsumer<T> monitoringListener) {
        return this.addListener(new EventListenerImpl.MonitoringListener(this.eventType, monitoringListener));
    }

    @Override
    public boolean post(T event) {
        return ((Predicate)this.getInvoker()).test(event);
    }

    @Override
    public T fire(T event) {
        ((Predicate)this.getInvoker()).test(event);
        return event;
    }

    @Override
    public boolean hasListeners() {
        return (Predicate)this.getInvoker() != Constants.NO_OP_PREDICATE;
    }

    @Override
    public @Nullable Predicate<T> maybeGetInvoker() {
        try {
            return this.invokerCallSite.getTarget().invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void invalidateInvoker() {
        this.invokerCallSite.setTarget(this.backingList.isEmpty() ? Constants.MH_NO_OP_PREDICATE : Constants.MH_NULL_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate<T> buildInvoker() {
        ArrayList<EventListener> arrayList = this.backingList;
        synchronized (arrayList) {
            this.backingList.sort(Constants.PRIORITY_COMPARATOR);
            if (Constants.isSelfDestructing(this.eventCharacteristics())) {
                this.monitorBackingList.add(new EventListenerImpl.MonitoringListener(this.eventType, (event, wasCancelled) -> this.dispose()));
            }
            Predicate<T> invoker = this.setInvoker(InvokerFactory.createCancellableMonitoringInvoker(this.eventType, this.eventCharacteristics, this.backingList, this.monitorBackingList));
            this.alreadyInvalidated.set(false);
            return invoker;
        }
    }

    @Override
    public void setNoOpInvoker() {
        this.invokerCallSite.setTarget(Constants.MH_NO_OP_PREDICATE);
    }

    private Predicate<T> setInvoker(Predicate<T> invoker) {
        this.invokerCallSite.setTarget(MethodHandles.constant(Predicate.class, invoker));
        return invoker;
    }
}

